/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.modeler.param;

import io.cdap.mmds.modeler.param.TreeParams;
import io.cdap.mmds.spec.DoubleParam;
import io.cdap.mmds.spec.IntParam;
import io.cdap.mmds.spec.ParamSpec;
import io.cdap.mmds.spec.Params;
import io.cdap.mmds.spec.Range;
import java.util.List;
import java.util.Map;

public class GBTParams
extends TreeParams {
    protected final IntParam maxIterations;
    protected final DoubleParam subsamplingRate;
    protected final DoubleParam stepSize;

    public GBTParams(Map<String, String> modelParams) {
        super(modelParams);
        this.maxIterations = new IntParam("maxIterations", "Max Iterations", "maximum number of iterations", 20, new Range(0, true), modelParams);
        this.subsamplingRate = new DoubleParam("subsamplingRate", "Sub-sampling Rate", "Fraction of the training data used for learning each decision tree.", 1.0, new Range(0.0, 1.0, false, true), modelParams);
        this.stepSize = new DoubleParam("stepSize", "Step Size", "Step size (a.k.a. learning rate) for shrinking the contribution of each estimator.", 0.1, new Range(0.0, 1.0, false, true), modelParams);
    }

    @Override
    public Map<String, String> toMap() {
        return Params.putParams(super.toMap(), this.maxIterations, this.subsamplingRate, this.stepSize);
    }

    @Override
    public List<ParamSpec> getSpec() {
        return Params.addParams(super.getSpec(), this.maxIterations, this.subsamplingRate, this.stepSize);
    }
}

