/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.mmds.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class Model {
    private final String name;
    private final String description;
    private final String algorithm;
    private final String split;
    private final String predictionsDataset;
    private final List<String> directives;
    private final Map<String, String> hyperparameters;

    protected Model(String name, String description, String algorithm, String split, @Nullable String predictionsDataset, List<String> directives, Map<String, String> hyperparameters) {
        this.name = name;
        this.description = description;
        this.algorithm = algorithm;
        this.split = split;
        this.predictionsDataset = predictionsDataset;
        this.directives = Collections.unmodifiableList(directives);
        this.hyperparameters = Collections.unmodifiableMap(hyperparameters);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description == null ? "" : this.description;
    }

    public List<String> getDirectives() {
        return this.directives;
    }

    @Nullable
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Nullable
    public String getSplit() {
        return this.split;
    }

    @Nullable
    public String getPredictionsDataset() {
        return this.predictionsDataset;
    }

    public Map<String, String> getHyperparameters() {
        return this.hyperparameters == null ? Collections.emptyMap() : this.hyperparameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model that = (Model)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.algorithm, that.algorithm) && Objects.equals(this.split, that.split) && Objects.equals(this.predictionsDataset, that.predictionsDataset) && Objects.equals(this.hyperparameters, that.hyperparameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.algorithm, this.split, this.predictionsDataset, this.hyperparameters);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder<T extends Builder> {
        protected String name;
        protected String description;
        protected String algorithm;
        protected String split;
        protected String predictionsDataset;
        protected List<String> directives = new ArrayList<String>();
        protected Map<String, String> hyperparameters = new HashMap<String, String>();

        protected Builder() {
        }

        public T setName(String name) {
            this.name = name;
            return (T)this;
        }

        public T setDescription(String description) {
            this.description = description;
            return (T)this;
        }

        public T setSplit(String split) {
            this.split = split;
            return (T)this;
        }

        public T setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
            return (T)this;
        }

        public T setPredictionsDataset(String predictionsDataset) {
            this.predictionsDataset = predictionsDataset;
            return (T)this;
        }

        public T setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperparameters.clear();
            this.hyperparameters.putAll(hyperParameters);
            return (T)this;
        }

        public T setDirectives(List<String> directives) {
            this.directives.clear();
            this.directives.addAll(directives);
            return (T)this;
        }

        public Model build() {
            return new Model(this.name, this.description, this.algorithm, this.split, this.predictionsDataset, this.directives, this.hyperparameters);
        }
    }
}

