/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.AbstractHttpResponder;
import io.cdap.http.BodyProducer;
import io.cdap.http.ChunkResponder;
import io.cdap.http.internal.InternalHttpResponse;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalHttpResponder
extends AbstractHttpResponder {
    private static final Logger LOG = LoggerFactory.getLogger(InternalHttpResponder.class);
    private InternalHttpResponse response;

    @Override
    public ChunkResponder sendChunkStart(final HttpResponseStatus status, HttpHeaders headers) {
        return new ChunkResponder(){
            private ByteBuf contentChunks = Unpooled.EMPTY_BUFFER;
            private boolean closed;

            @Override
            public void sendChunk(ByteBuffer chunk) throws IOException {
                this.sendChunk(Unpooled.wrappedBuffer((ByteBuffer)chunk));
            }

            @Override
            public synchronized void sendChunk(ByteBuf chunk) throws IOException {
                if (this.closed) {
                    throw new IOException("ChunkResponder already closed.");
                }
                this.contentChunks = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{this.contentChunks, chunk});
            }

            @Override
            public synchronized void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                InternalHttpResponder.this.response = new AbstractInternalResponse(status.code()){

                    @Override
                    public InputStream openInputStream() throws IOException {
                        return new ByteBufInputStream(contentChunks.duplicate());
                    }
                };
            }
        };
    }

    @Override
    public void sendContent(HttpResponseStatus status, final ByteBuf content, HttpHeaders headers) {
        this.response = new AbstractInternalResponse(status.code()){

            @Override
            public InputStream openInputStream() throws IOException {
                return new ByteBufInputStream(content.duplicate());
            }
        };
    }

    @Override
    public void sendFile(final File file, HttpHeaders headers) {
        this.response = new AbstractInternalResponse(HttpResponseStatus.OK.code()){

            @Override
            public InputStream openInputStream() throws IOException {
                return new FileInputStream(file);
            }
        };
    }

    @Override
    public void sendContent(HttpResponseStatus status, BodyProducer bodyProducer, HttpHeaders headers) {
        ByteBuf contentChunks = Unpooled.EMPTY_BUFFER;
        try {
            ByteBuf chunk = bodyProducer.nextChunk();
            while (chunk.isReadable()) {
                contentChunks = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{contentChunks, chunk});
                chunk = bodyProducer.nextChunk();
            }
            bodyProducer.finished();
            final ByteBuf finalContentChunks = contentChunks;
            this.response = new AbstractInternalResponse(status.code()){

                @Override
                public InputStream openInputStream() throws IOException {
                    return new ByteBufInputStream(finalContentChunks.duplicate());
                }
            };
        }
        catch (Throwable t) {
            try {
                bodyProducer.handleError(t);
            }
            catch (Throwable et) {
                LOG.warn("Exception raised from BodyProducer.handleError() for {}", (Object)bodyProducer, (Object)et);
            }
        }
    }

    public InternalHttpResponse getResponse() {
        if (this.response == null) {
            throw new IllegalStateException("No InternalHttpResponse available");
        }
        return this.response;
    }

    private static abstract class AbstractInternalResponse
    implements InternalHttpResponse {
        private final int statusCode;

        AbstractInternalResponse(int statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

