/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import java.util.Objects;

final class ImmutablePair<A, B> {
    private final A first;
    private final B second;

    public static <A, B> ImmutablePair<A, B> of(A first, B second) {
        return new ImmutablePair<A, B>(first, second);
    }

    private ImmutablePair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public String toString() {
        return "ImmutablePair{first=" + this.first + ", second=" + this.second + '}';
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof ImmutablePair)) {
            return false;
        }
        ImmutablePair other = (ImmutablePair)o;
        return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
    }
}

