/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.ExceptionHandler;
import io.cdap.http.HttpHandler;
import io.cdap.http.HttpResponder;
import io.cdap.http.internal.Converter;
import io.cdap.http.internal.HandlerException;
import io.cdap.http.internal.HttpMethodInfo;
import io.cdap.http.internal.ParamConvertUtils;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;

public final class HttpResourceModel {
    private static final Set<Class<? extends Annotation>> SUPPORTED_PARAM_ANNOTATIONS = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(PathParam.class, QueryParam.class, HeaderParam.class)));
    private final Set<HttpMethod> httpMethods;
    private final String path;
    private final Method method;
    private final HttpHandler handler;
    private final List<Map<Class<? extends Annotation>, ParameterInfo<?>>> paramsInfo;
    private final ExceptionHandler exceptionHandler;
    private final boolean isSecured;
    private final String[] requiredRoles;

    public HttpResourceModel(Set<HttpMethod> httpMethods, String path, Method method, HttpHandler handler, ExceptionHandler exceptionHandler, boolean isSecured, String[] requiredRoles) {
        this.httpMethods = httpMethods;
        this.path = path;
        this.method = method;
        this.handler = handler;
        this.paramsInfo = this.createParametersInfos(method);
        this.exceptionHandler = exceptionHandler;
        this.isSecured = isSecured;
        this.requiredRoles = requiredRoles;
    }

    public Set<HttpMethod> getHttpMethod() {
        return this.httpMethods;
    }

    public String getPath() {
        return this.path;
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpHandler getHttpHandler() {
        return this.handler;
    }

    public HttpMethodInfo handle(HttpRequest request, HttpResponder responder, Map<String, String> groupValues) throws Exception {
        try {
            if (this.httpMethods.contains(request.method())) {
                Object[] args = new Object[this.paramsInfo.size()];
                int idx = 0;
                for (Map<Class<Annotation>, ParameterInfo<?>> info : this.paramsInfo) {
                    if (info.containsKey(PathParam.class)) {
                        args[idx] = this.getPathParamValue(info, groupValues);
                    }
                    if (info.containsKey(QueryParam.class)) {
                        args[idx] = this.getQueryParamValue(info, request.uri());
                    }
                    if (info.containsKey(HeaderParam.class)) {
                        args[idx] = this.getHeaderParamValue(info, request);
                    }
                    ++idx;
                }
                return new HttpMethodInfo(this.method, this.handler, responder, args, this.exceptionHandler, this.isSecured, this.requiredRoles);
            }
            throw new HandlerException(HttpResponseStatus.METHOD_NOT_ALLOWED, String.format("Problem accessing: %s. Reason: Method Not Allowed", request.uri()));
        }
        catch (Throwable e) {
            throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Error in executing request: %s %s", request.method(), request.uri()), e);
        }
    }

    public String toString() {
        return "HttpResourceModel{httpMethods=" + this.httpMethods + ", path='" + this.path + '\'' + ", method=" + this.method + ", handler=" + this.handler + '}';
    }

    private Object getPathParamValue(Map<Class<? extends Annotation>, ParameterInfo<?>> annotations, Map<String, String> groupValues) throws Exception {
        ParameterInfo<?> info = annotations.get(PathParam.class);
        PathParam pathParam = (PathParam)info.getAnnotation();
        String value = groupValues.get(pathParam.value());
        if (value == null) {
            throw new IllegalArgumentException("Could not resolve value for path parameter " + pathParam.value());
        }
        return info.convert(value);
    }

    private Object getQueryParamValue(Map<Class<? extends Annotation>, ParameterInfo<?>> annotations, String uri) throws Exception {
        ParameterInfo<?> info = annotations.get(QueryParam.class);
        QueryParam queryParam = (QueryParam)info.getAnnotation();
        List values = (List)new QueryStringDecoder(uri).parameters().get(queryParam.value());
        return values == null ? info.convert(this.defaultValue(annotations)) : info.convert(values);
    }

    private Object getHeaderParamValue(Map<Class<? extends Annotation>, ParameterInfo<?>> annotations, HttpRequest request) throws Exception {
        ParameterInfo<?> info = annotations.get(HeaderParam.class);
        HeaderParam headerParam = (HeaderParam)info.getAnnotation();
        String headerName = headerParam.value();
        boolean hasHeader = request.headers().contains(headerName);
        return hasHeader ? info.convert(request.headers().getAll(headerName)) : info.convert(this.defaultValue(annotations));
    }

    private List<String> defaultValue(Map<Class<? extends Annotation>, ParameterInfo<?>> annotations) {
        ParameterInfo<?> defaultInfo = annotations.get(DefaultValue.class);
        if (defaultInfo == null) {
            return Collections.emptyList();
        }
        DefaultValue defaultValue = (DefaultValue)defaultInfo.getAnnotation();
        return Collections.singletonList(defaultValue.value());
    }

    private List<Map<Class<? extends Annotation>, ParameterInfo<?>>> createParametersInfos(Method method) {
        if (method.getParameterTypes().length <= 2) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        Type[] parameterTypes = method.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 2; i < parameterAnnotations.length; ++i) {
            Annotation[] annotations = parameterAnnotations[i];
            IdentityHashMap<Class<? extends Annotation>, ParameterInfo<String>> paramAnnotations = new IdentityHashMap<Class<? extends Annotation>, ParameterInfo<String>>();
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                ParameterInfo<Object> parameterInfo = PathParam.class.isAssignableFrom(annotationType) ? ParameterInfo.create(annotation, ParamConvertUtils.createPathParamConverter(parameterTypes[i])) : (QueryParam.class.isAssignableFrom(annotationType) ? ParameterInfo.create(annotation, ParamConvertUtils.createQueryParamConverter(parameterTypes[i])) : (HeaderParam.class.isAssignableFrom(annotationType) ? ParameterInfo.create(annotation, ParamConvertUtils.createHeaderParamConverter(parameterTypes[i])) : ParameterInfo.create(annotation, null)));
                paramAnnotations.put(annotationType, parameterInfo);
            }
            int presence = 0;
            for (Class annotationClass : paramAnnotations.keySet()) {
                if (!SUPPORTED_PARAM_ANNOTATIONS.contains(annotationClass)) continue;
                ++presence;
            }
            if (presence != 1) {
                throw new IllegalArgumentException(String.format("Must have exactly one annotation from %s for parameter %d in method %s", SUPPORTED_PARAM_ANNOTATIONS, i, method));
            }
            result.add(Collections.unmodifiableMap(paramAnnotations));
        }
        return Collections.unmodifiableList(result);
    }

    private static final class ParameterInfo<T> {
        private final Annotation annotation;
        private final Converter<T, Object> converter;

        static <V> ParameterInfo<V> create(Annotation annotation, @Nullable Converter<V, Object> converter) {
            return new ParameterInfo<V>(annotation, converter);
        }

        private ParameterInfo(Annotation annotation, @Nullable Converter<T, Object> converter) {
            this.annotation = annotation;
            this.converter = converter;
        }

        <V extends Annotation> V getAnnotation() {
            return (V)this.annotation;
        }

        Object convert(T input) throws Exception {
            return this.converter == null ? null : this.converter.convert(input);
        }
    }
}

