/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.AbstractHttpResponder;
import io.cdap.http.BodyProducer;
import io.cdap.http.ChunkResponder;
import io.cdap.http.HandlerHook;
import io.cdap.http.HttpResponder;
import io.cdap.http.internal.HandlerInfo;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class WrappedHttpResponder
extends AbstractHttpResponder {
    private static final Logger LOG = LoggerFactory.getLogger(WrappedHttpResponder.class);
    private final HttpResponder delegate;
    private final Iterable<? extends HandlerHook> handlerHooks;
    private final HttpRequest httpRequest;
    private final HandlerInfo handlerInfo;

    WrappedHttpResponder(HttpResponder delegate, Iterable<? extends HandlerHook> handlerHooks, HttpRequest httpRequest, HandlerInfo handlerInfo) {
        this.delegate = delegate;
        this.handlerHooks = handlerHooks;
        this.httpRequest = httpRequest;
        this.handlerInfo = handlerInfo;
    }

    @Override
    public ChunkResponder sendChunkStart(final HttpResponseStatus status, HttpHeaders headers) {
        final ChunkResponder chunkResponder = this.delegate.sendChunkStart(status, headers);
        return new ChunkResponder(){

            @Override
            public void sendChunk(ByteBuffer chunk) throws IOException {
                chunkResponder.sendChunk(chunk);
            }

            @Override
            public void sendChunk(ByteBuf chunk) throws IOException {
                chunkResponder.sendChunk(chunk);
            }

            @Override
            public void flush() {
                chunkResponder.flush();
            }

            @Override
            public void close() throws IOException {
                chunkResponder.close();
                WrappedHttpResponder.this.runHook(status);
            }
        };
    }

    @Override
    public void sendContent(HttpResponseStatus status, ByteBuf content, HttpHeaders headers) {
        this.delegate.sendContent(status, content, headers);
        this.runHook(status);
    }

    @Override
    public void sendFile(File file, HttpHeaders headers) throws IOException {
        this.delegate.sendFile(file, headers);
        this.runHook(HttpResponseStatus.OK);
    }

    @Override
    public void sendContent(HttpResponseStatus status, BodyProducer bodyProducer, HttpHeaders headers) {
        this.delegate.sendContent(status, bodyProducer, headers);
        this.runHook(status);
    }

    private void runHook(HttpResponseStatus status) {
        for (HandlerHook handlerHook : this.handlerHooks) {
            try {
                handlerHook.postCall(this.httpRequest, status, this.handlerInfo);
            }
            catch (Throwable t) {
                LOG.error("Post handler hook threw exception: ", t);
            }
        }
    }
}

