/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.ChunkResponder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

final class ChannelChunkResponder
implements ChunkResponder {
    private final Channel channel;
    private final AtomicBoolean closed;
    private final AtomicLong bufferedSize;
    private final int chunkMemoryLimit;

    ChannelChunkResponder(Channel channel, int chunkMemoryLimit) {
        this.channel = channel;
        this.closed = new AtomicBoolean();
        this.bufferedSize = new AtomicLong();
        this.chunkMemoryLimit = chunkMemoryLimit;
    }

    @Override
    public void sendChunk(ByteBuffer chunk) throws IOException {
        this.sendChunk(Unpooled.wrappedBuffer((ByteBuffer)chunk));
    }

    @Override
    public void sendChunk(ByteBuf chunk) throws IOException {
        if (this.closed.get()) {
            throw new IOException("ChunkResponder already closed.");
        }
        if (!this.channel.isActive()) {
            throw new IOException("Connection already closed.");
        }
        int chunkSize = chunk.readableBytes();
        this.channel.write((Object)new DefaultHttpContent(chunk));
        this.tryFlush(chunkSize);
    }

    @Override
    public void flush() {
        this.tryFlush(this.chunkMemoryLimit);
    }

    @Override
    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
    }

    private void tryFlush(int size) {
        long newSize = this.bufferedSize.addAndGet(size);
        if (newSize >= (long)this.chunkMemoryLimit) {
            this.channel.flush();
            this.bufferedSize.addAndGet(-1L * newSize);
        }
    }
}

