/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.HttpResponder;
import io.cdap.http.internal.BasicHttpResponder;
import io.cdap.http.internal.HandlerException;
import io.cdap.http.internal.HttpDispatcher;
import io.cdap.http.internal.HttpMethodInfo;
import io.cdap.http.internal.HttpResourceHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestRouter
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(HttpDispatcher.class);
    private final int chunkMemoryLimit;
    private final HttpResourceHandler httpMethodHandler;
    private final AtomicBoolean exceptionRaised;
    private final boolean sslEnabled;
    private HttpMethodInfo methodInfo;

    public RequestRouter(HttpResourceHandler methodHandler, int chunkMemoryLimit, boolean sslEnabled) {
        this.httpMethodHandler = methodHandler;
        this.chunkMemoryLimit = chunkMemoryLimit;
        this.exceptionRaised = new AtomicBoolean(false);
        this.sslEnabled = sslEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (this.exceptionRaised.get()) {
                return;
            }
            if (!(msg instanceof HttpRequest)) {
                if (this.methodInfo != null) {
                    ReferenceCountUtil.retain((Object)msg);
                    ctx.fireChannelRead(msg);
                }
                return;
            }
            HttpRequest request = (HttpRequest)msg;
            BasicHttpResponder responder = new BasicHttpResponder(ctx.channel(), this.sslEnabled);
            this.methodInfo = null;
            this.methodInfo = this.prepareHandleMethod(request, responder, ctx);
            if (this.methodInfo != null) {
                ReferenceCountUtil.retain((Object)msg);
                ctx.fireChannelRead(msg);
            } else if (!responder.isResponded()) {
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
                HttpUtil.setContentLength((HttpMessage)response, (long)0L);
                HttpUtil.setKeepAlive((HttpMessage)response, (boolean)false);
                ctx.channel().writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                ctx.channel().close();
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String exceptionMessage = "Exception caught in channel processing.";
        if (this.exceptionRaised.compareAndSet(false, true)) {
            if (this.methodInfo != null) {
                this.methodInfo.sendError(HttpResponseStatus.INTERNAL_SERVER_ERROR, cause);
                this.methodInfo = null;
            } else if (cause instanceof HandlerException) {
                HttpResponse response = ((HandlerException)cause).createFailureResponse();
                HttpUtil.setKeepAlive((HttpMessage)response, (boolean)false);
                if (this.isUserError(response)) {
                    LOG.trace(exceptionMessage, cause);
                } else {
                    LOG.error(exceptionMessage, cause);
                }
                ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                LOG.error(exceptionMessage, cause);
                DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                HttpUtil.setContentLength((HttpMessage)response, (long)0L);
                HttpUtil.setKeepAlive((HttpMessage)response, (boolean)false);
                ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        } else {
            LOG.trace(exceptionMessage, cause);
        }
    }

    @Nullable
    private HttpMethodInfo prepareHandleMethod(HttpRequest httpRequest, HttpResponder responder, ChannelHandlerContext ctx) throws Exception {
        HttpMethodInfo methodInfo = this.httpMethodHandler.getDestinationMethod(httpRequest, responder);
        if (methodInfo == null) {
            return null;
        }
        ctx.channel().attr(HttpDispatcher.METHOD_INFO_KEY).set((Object)methodInfo);
        ChannelPipeline pipeline = ctx.channel().pipeline();
        if (methodInfo.isStreaming()) {
            if (pipeline.get("aggregator") != null) {
                pipeline.remove("aggregator");
            }
            if (pipeline.get("continue") == null) {
                pipeline.addAfter("router", "continue", (ChannelHandler)new HttpServerExpectContinueHandler());
            }
        } else {
            if (pipeline.get("continue") != null) {
                pipeline.remove("continue");
            }
            if (pipeline.get("aggregator") == null) {
                pipeline.addAfter("router", "aggregator", (ChannelHandler)new HttpObjectAggregator(this.chunkMemoryLimit));
            }
        }
        return methodInfo;
    }

    private boolean isUserError(HttpResponse response) {
        int code = response.status().code();
        return code == HttpResponseStatus.BAD_REQUEST.code() || code == HttpResponseStatus.NOT_FOUND.code() || code == HttpResponseStatus.METHOD_NOT_ALLOWED.code() || code == HttpResponseStatus.UNAUTHORIZED.code() || code == HttpResponseStatus.FORBIDDEN.code();
    }
}

