/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.ChunkResponder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.LastHttpContent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;

final class ChannelChunkResponder
implements ChunkResponder {
    private final Channel channel;
    private final AtomicBoolean closed;

    ChannelChunkResponder(Channel channel) {
        this.channel = channel;
        this.closed = new AtomicBoolean(false);
    }

    @Override
    public void sendChunk(ByteBuffer chunk) throws IOException {
        this.sendChunk(Unpooled.wrappedBuffer((ByteBuffer)chunk));
    }

    @Override
    public void sendChunk(ByteBuf chunk) throws IOException {
        if (this.closed.get()) {
            throw new IOException("ChunkResponder already closed.");
        }
        if (!this.channel.isActive()) {
            throw new IOException("Connection already closed.");
        }
        this.channel.write((Object)new DefaultHttpContent(chunk));
    }

    @Override
    public void close() throws IOException {
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
    }
}

