/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.AbstractHttpResponder;
import io.cdap.http.BodyProducer;
import io.cdap.http.ChunkResponder;
import io.cdap.http.internal.ChannelChunkResponder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BasicHttpResponder
extends AbstractHttpResponder {
    private static final Logger LOG = LoggerFactory.getLogger(BasicHttpResponder.class);
    private final Channel channel;
    private final AtomicBoolean responded;
    private final boolean sslEnabled;

    BasicHttpResponder(Channel channel, boolean sslEnabled) {
        this.channel = channel;
        this.responded = new AtomicBoolean(false);
        this.sslEnabled = sslEnabled;
    }

    @Override
    public ChunkResponder sendChunkStart(HttpResponseStatus status, HttpHeaders headers) {
        if (status.code() < 200 || status.code() >= 210) {
            throw new IllegalArgumentException("Status code must be between 200 and 210. Status code provided is " + status.code());
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        this.addContentTypeIfMissing(response.headers().add(headers), "application/octet-stream");
        if (HttpUtil.getContentLength((HttpMessage)response, (long)-1L) < 0L) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
        }
        this.checkNotResponded();
        this.channel.write((Object)response);
        return new ChannelChunkResponder(this.channel);
    }

    @Override
    public void sendContent(HttpResponseStatus status, ByteBuf content, HttpHeaders headers) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        response.headers().add(headers);
        HttpUtil.setContentLength((HttpMessage)response, (long)content.readableBytes());
        if (content.isReadable()) {
            this.addContentTypeIfMissing(response.headers(), "application/octet-stream");
        }
        this.checkNotResponded();
        this.channel.writeAndFlush((Object)response);
    }

    @Override
    public void sendFile(File file, HttpHeaders headers) throws IOException {
        block7: {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            this.addContentTypeIfMissing(response.headers().add(headers), "application/octet-stream");
            HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)false);
            HttpUtil.setContentLength((HttpMessage)response, (long)file.length());
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            try {
                this.checkNotResponded();
                this.channel.write((Object)response);
                if (this.sslEnabled) {
                    this.channel.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 8192)));
                    break block7;
                }
                final Runnable completion = this.prepareSendFile(this.channel);
                try {
                    DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), 0L, file.length());
                    this.channel.write((Object)region);
                    this.channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) {
                            completion.run();
                        }
                    });
                }
                catch (Throwable t) {
                    completion.run();
                    throw t;
                }
            }
            catch (Throwable t) {
                try {
                    raf.close();
                }
                catch (IOException ex) {
                    t.addSuppressed(ex);
                }
                throw t;
            }
        }
    }

    @Override
    public void sendContent(HttpResponseStatus status, final BodyProducer bodyProducer, HttpHeaders headers) {
        long contentLength;
        try {
            contentLength = bodyProducer.getContentLength();
        }
        catch (Throwable t) {
            bodyProducer.handleError(t);
            this.sendContent(HttpResponseStatus.INTERNAL_SERVER_ERROR, Unpooled.copiedBuffer((CharSequence)("Failed to determined content length. Cause: " + t.getMessage()), (Charset)StandardCharsets.UTF_8), new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE).set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=utf-8"));
            return;
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        this.addContentTypeIfMissing(response.headers().add(headers), "application/octet-stream");
        if (contentLength < 0L) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
        } else {
            HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)false);
            HttpUtil.setContentLength((HttpMessage)response, (long)contentLength);
        }
        this.checkNotResponded();
        this.channel.writeAndFlush((Object)response).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    BasicHttpResponder.this.callBodyProducerHandleError(bodyProducer, future.cause());
                    BasicHttpResponder.this.channel.close();
                    return;
                }
                BasicHttpResponder.this.channel.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new BodyProducerChunkedInput(bodyProducer, contentLength))).addListener((GenericFutureListener)BasicHttpResponder.this.createBodyProducerCompletionListener(bodyProducer));
            }
        });
    }

    boolean isResponded() {
        return this.responded.get();
    }

    private ChannelFutureListener createBodyProducerCompletionListener(final BodyProducer bodyProducer) {
        return new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    BasicHttpResponder.this.callBodyProducerHandleError(bodyProducer, future.cause());
                    BasicHttpResponder.this.channel.close();
                    return;
                }
                try {
                    bodyProducer.finished();
                }
                catch (Throwable t) {
                    BasicHttpResponder.this.callBodyProducerHandleError(bodyProducer, t);
                    BasicHttpResponder.this.channel.close();
                }
            }
        };
    }

    private void callBodyProducerHandleError(BodyProducer bodyProducer, @Nullable Throwable failureCause) {
        try {
            bodyProducer.handleError(failureCause);
        }
        catch (Throwable t) {
            LOG.warn("Exception raised from BodyProducer.handleError() for {}", (Object)bodyProducer, (Object)t);
        }
    }

    private void checkNotResponded() {
        if (!this.responded.compareAndSet(false, true)) {
            throw new IllegalStateException("Response has already been sent");
        }
    }

    private Runnable prepareSendFile(Channel channel) {
        try {
            final ChannelPipeline pipeline = channel.pipeline();
            pipeline.remove("compressor");
            return new Runnable(){

                @Override
                public void run() {
                    pipeline.addAfter("codec", "compressor", (ChannelHandler)new HttpContentCompressor());
                }
            };
        }
        catch (NoSuchElementException e) {
            return new Runnable(){

                @Override
                public void run() {
                }
            };
        }
    }

    private static final class BodyProducerChunkedInput
    implements ChunkedInput<ByteBuf> {
        private final BodyProducer bodyProducer;
        private final long length;
        private long bytesProduced;
        private ByteBuf nextChunk;
        private boolean completed;

        private BodyProducerChunkedInput(BodyProducer bodyProducer, long length) {
            this.bodyProducer = bodyProducer;
            this.length = length;
        }

        public boolean isEndOfInput() throws Exception {
            if (this.completed) {
                return true;
            }
            if (this.nextChunk == null) {
                this.nextChunk = this.bodyProducer.nextChunk();
            }
            boolean bl = this.completed = !this.nextChunk.isReadable();
            if (this.completed && this.length >= 0L && this.bytesProduced != this.length) {
                throw new IllegalStateException("Body size doesn't match with content length. Content-Length: " + this.length + ", bytes produced: " + this.bytesProduced);
            }
            return this.completed;
        }

        public void close() throws Exception {
        }

        public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
            return this.readChunk(ctx.alloc());
        }

        public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
            if (this.isEndOfInput()) {
                throw new IllegalStateException("No more data to produce from body producer");
            }
            ByteBuf chunk = this.nextChunk;
            this.bytesProduced += (long)chunk.readableBytes();
            this.nextChunk = null;
            return chunk;
        }

        public long length() {
            return this.length;
        }

        public long progress() {
            return this.length >= 0L ? this.bytesProduced : 0L;
        }
    }
}

