/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http;

import io.cdap.http.AuthHandler;
import io.cdap.http.ChannelPipelineModifier;
import io.cdap.http.ExceptionHandler;
import io.cdap.http.HandlerContext;
import io.cdap.http.HandlerHook;
import io.cdap.http.HttpHandler;
import io.cdap.http.SSLConfig;
import io.cdap.http.SSLHandlerFactory;
import io.cdap.http.URLRewriter;
import io.cdap.http.internal.BasicHandlerContext;
import io.cdap.http.internal.HttpDispatcher;
import io.cdap.http.internal.HttpResourceHandler;
import io.cdap.http.internal.NonStickyEventExecutorGroup;
import io.cdap.http.internal.RequestRouter;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.UnorderedThreadPoolEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyHttpService {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpService.class);
    private final String serviceName;
    private final int bossThreadPoolSize;
    private final int workerThreadPoolSize;
    private final int execThreadPoolSize;
    private final long execThreadKeepAliveSecs;
    private final Map<ChannelOption, Object> channelConfigs;
    private final Map<ChannelOption, Object> childChannelConfigs;
    private final RejectedExecutionHandler rejectedExecutionHandler;
    private final HandlerContext handlerContext;
    private final HttpResourceHandler resourceHandler;
    private final ChannelPipelineModifier pipelineModifier;
    private final int httpChunkLimit;
    private final SSLHandlerFactory sslHandlerFactory;
    private State state;
    private ServerBootstrap bootstrap;
    private ChannelGroup channelGroup;
    private EventExecutorGroup eventExecutorGroup;
    private InetSocketAddress bindAddress;

    private NettyHttpService(String serviceName, InetSocketAddress bindAddress, int bossThreadPoolSize, int workerThreadPoolSize, int execThreadPoolSize, long execThreadKeepAliveSecs, Map<ChannelOption, Object> channelConfigs, Map<ChannelOption, Object> childChannelConfigs, RejectedExecutionHandler rejectedExecutionHandler, URLRewriter urlRewriter, Iterable<? extends HttpHandler> httpHandlers, Iterable<? extends HandlerHook> handlerHooks, int httpChunkLimit, ChannelPipelineModifier pipelineModifier, SSLHandlerFactory sslHandlerFactory, ExceptionHandler exceptionHandler, AuthHandler authHandler) {
        this.serviceName = serviceName;
        this.bindAddress = bindAddress;
        this.bossThreadPoolSize = bossThreadPoolSize;
        this.workerThreadPoolSize = workerThreadPoolSize;
        this.execThreadPoolSize = execThreadPoolSize;
        this.execThreadKeepAliveSecs = execThreadKeepAliveSecs;
        this.channelConfigs = new HashMap<ChannelOption, Object>(channelConfigs);
        this.childChannelConfigs = new HashMap<ChannelOption, Object>(childChannelConfigs);
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        this.resourceHandler = new HttpResourceHandler(httpHandlers, handlerHooks, urlRewriter, exceptionHandler, authHandler);
        this.handlerContext = new BasicHandlerContext(this.resourceHandler);
        this.httpChunkLimit = httpChunkLimit;
        this.pipelineModifier = pipelineModifier;
        this.sslHandlerFactory = sslHandlerFactory;
        this.state = State.NOT_STARTED;
    }

    public static Builder builder(String serviceName) {
        return new Builder(serviceName);
    }

    public synchronized void start() throws Exception {
        if (this.state == State.RUNNING) {
            LOG.debug("Ignore start() call on HTTP service {} since it has already been started.", (Object)this.serviceName);
            return;
        }
        if (this.state != State.NOT_STARTED) {
            if (this.state == State.STOPPED) {
                throw new IllegalStateException("Cannot start the HTTP service " + this.serviceName + " again since it has been stopped");
            }
            throw new IllegalStateException("Cannot start the HTTP service " + this.serviceName + " because it was failed earlier");
        }
        try {
            LOG.info("Starting HTTP Service {} at address {}", (Object)this.serviceName, (Object)this.bindAddress);
            this.channelGroup = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
            this.resourceHandler.init(this.handlerContext);
            this.eventExecutorGroup = this.createEventExecutorGroup(this.execThreadPoolSize);
            this.bootstrap = this.createBootstrap(this.channelGroup);
            Channel serverChannel = this.bootstrap.bind((SocketAddress)this.bindAddress).sync().channel();
            this.channelGroup.add((Object)serverChannel);
            this.bindAddress = (InetSocketAddress)serverChannel.localAddress();
            LOG.debug("Started HTTP Service {} at address {}", (Object)this.serviceName, (Object)this.bindAddress);
            this.state = State.RUNNING;
        }
        catch (Throwable t) {
            this.channelGroup.close().awaitUninterruptibly();
            try {
                if (this.bootstrap != null) {
                    this.shutdownExecutorGroups(0L, 5L, TimeUnit.SECONDS, new EventExecutorGroup[]{this.bootstrap.config().group(), this.bootstrap.config().childGroup(), this.eventExecutorGroup});
                } else {
                    this.shutdownExecutorGroups(0L, 5L, TimeUnit.SECONDS, this.eventExecutorGroup);
                }
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            this.state = State.FAILED;
            throw t;
        }
    }

    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isSSLEnabled() {
        return this.sslHandlerFactory != null;
    }

    public void stop() throws Exception {
        this.stop(0L, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(long quietPeriod, long timeout, TimeUnit unit) throws Exception {
        if (this.state == State.STOPPED) {
            LOG.debug("Ignore stop() call on HTTP service {} since it has already been stopped.", (Object)this.serviceName);
            return;
        }
        LOG.info("Stopping HTTP Service {}", (Object)this.serviceName);
        try {
            try {
                this.channelGroup.close().awaitUninterruptibly();
            }
            catch (Throwable throwable) {
                try {
                    this.shutdownExecutorGroups(quietPeriod, timeout, unit, new EventExecutorGroup[]{this.bootstrap.config().group(), this.bootstrap.config().childGroup(), this.eventExecutorGroup});
                }
                finally {
                    this.resourceHandler.destroy(this.handlerContext);
                }
                throw throwable;
            }
            try {
                this.shutdownExecutorGroups(quietPeriod, timeout, unit, new EventExecutorGroup[]{this.bootstrap.config().group(), this.bootstrap.config().childGroup(), this.eventExecutorGroup});
            }
            finally {
                this.resourceHandler.destroy(this.handlerContext);
            }
        }
        catch (Throwable t) {
            this.state = State.FAILED;
            throw t;
        }
        this.state = State.STOPPED;
        LOG.debug("Stopped HTTP Service {} on address {}", (Object)this.serviceName, (Object)this.bindAddress);
    }

    @Nullable
    private EventExecutorGroup createEventExecutorGroup(int size) {
        if (size <= 0) {
            return null;
        }
        ThreadFactory threadFactory = new ThreadFactory(){
            private final ThreadGroup threadGroup;
            private final AtomicLong count;
            {
                this.threadGroup = new ThreadGroup(NettyHttpService.this.serviceName + "-executor-thread");
                this.count = new AtomicLong(0L);
            }

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(this.threadGroup, r, String.format("%s-executor-%d", NettyHttpService.this.serviceName, this.count.getAndIncrement()));
                t.setDaemon(true);
                return t;
            }
        };
        UnorderedThreadPoolEventExecutor executor = new UnorderedThreadPoolEventExecutor(size, threadFactory, this.rejectedExecutionHandler);
        if (this.execThreadKeepAliveSecs > 0L) {
            executor.setKeepAliveTime(this.execThreadKeepAliveSecs, TimeUnit.SECONDS);
            executor.allowCoreThreadTimeOut(true);
        }
        return new NonStickyEventExecutorGroup((EventExecutorGroup)executor);
    }

    private ThreadFactory createDaemonThreadFactory(final String nameFormat) {
        return new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName(String.format(nameFormat, this.count.getAndIncrement()));
                t.setDaemon(true);
                return t;
            }
        };
    }

    private ServerBootstrap createBootstrap(final ChannelGroup channelGroup) throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(this.bossThreadPoolSize, this.createDaemonThreadFactory(this.serviceName + "-boss-thread-%d"));
        NioEventLoopGroup workerGroup = new NioEventLoopGroup(this.workerThreadPoolSize, this.createDaemonThreadFactory(this.serviceName + "-worker-thread-%d"));
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                channelGroup.add((Object)ch);
                ChannelPipeline pipeline = ch.pipeline();
                if (NettyHttpService.this.sslHandlerFactory != null) {
                    pipeline.addLast("ssl", (ChannelHandler)NettyHttpService.this.sslHandlerFactory.create(ch.alloc()));
                }
                pipeline.addLast("codec", (ChannelHandler)new HttpServerCodec());
                pipeline.addLast("compressor", (ChannelHandler)new HttpContentCompressor());
                pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
                pipeline.addLast("keepAlive", (ChannelHandler)new HttpServerKeepAliveHandler());
                pipeline.addLast("router", (ChannelHandler)new RequestRouter(NettyHttpService.this.resourceHandler, NettyHttpService.this.httpChunkLimit, NettyHttpService.this.sslHandlerFactory != null));
                if (NettyHttpService.this.eventExecutorGroup == null) {
                    pipeline.addLast("dispatcher", (ChannelHandler)new HttpDispatcher());
                } else {
                    pipeline.addLast(NettyHttpService.this.eventExecutorGroup, "dispatcher", (ChannelHandler)new HttpDispatcher());
                }
                if (NettyHttpService.this.pipelineModifier != null) {
                    NettyHttpService.this.pipelineModifier.modify(pipeline);
                }
            }
        });
        for (Map.Entry<ChannelOption, Object> entry : this.channelConfigs.entrySet()) {
            bootstrap.option(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<ChannelOption, Object> entry : this.childChannelConfigs.entrySet()) {
            bootstrap.childOption(entry.getKey(), entry.getValue());
        }
        return bootstrap;
    }

    private void shutdownExecutorGroups(long quietPeriod, long timeout, TimeUnit unit, EventExecutorGroup ... groups) {
        Exception ex = null;
        ArrayList<Future> futures = new ArrayList<Future>();
        for (EventExecutorGroup group : groups) {
            if (group == null) continue;
            futures.add(group.shutdownGracefully(quietPeriod, timeout, unit));
        }
        for (Future future : futures) {
            try {
                future.syncUninterruptibly();
            }
            catch (Exception e) {
                if (ex == null) {
                    ex = e;
                    continue;
                }
                ex.addSuppressed(e);
            }
        }
        if (ex != null) {
            LOG.warn("Exception raised when shutting down executor", ex);
        }
    }

    public static class Builder {
        private static final int DEFAULT_BOSS_THREAD_POOL_SIZE = 1;
        private static final int DEFAULT_WORKER_THREAD_POOL_SIZE = 10;
        private static final int DEFAULT_CONNECTION_BACKLOG = 1000;
        private static final int DEFAULT_EXEC_HANDLER_THREAD_POOL_SIZE = 60;
        private static final long DEFAULT_EXEC_HANDLER_THREAD_KEEP_ALIVE_TIME_SECS = 60L;
        private static final RejectedExecutionHandler DEFAULT_REJECTED_EXECUTION_HANDLER = new ThreadPoolExecutor.CallerRunsPolicy();
        private static final int DEFAULT_HTTP_CHUNK_LIMIT = 0x9600000;
        private final String serviceName;
        private final Map<ChannelOption, Object> channelConfigs;
        private final Map<ChannelOption, Object> childChannelConfigs;
        private Iterable<? extends HttpHandler> handlers;
        private Iterable<? extends HandlerHook> handlerHooks = Collections.emptyList();
        private URLRewriter urlRewriter = null;
        private int bossThreadPoolSize;
        private int workerThreadPoolSize;
        private int execThreadPoolSize;
        private long execThreadKeepAliveSecs;
        private String host;
        private int port;
        private RejectedExecutionHandler rejectedExecutionHandler;
        private int httpChunkLimit;
        private SSLHandlerFactory sslHandlerFactory;
        private ChannelPipelineModifier pipelineModifier;
        private ExceptionHandler exceptionHandler;
        private AuthHandler authHandler;

        protected Builder(String serviceName) {
            this.serviceName = serviceName;
            this.bossThreadPoolSize = 1;
            this.workerThreadPoolSize = 10;
            this.execThreadPoolSize = 60;
            this.execThreadKeepAliveSecs = 60L;
            this.rejectedExecutionHandler = DEFAULT_REJECTED_EXECUTION_HANDLER;
            this.httpChunkLimit = 0x9600000;
            this.port = 0;
            this.channelConfigs = new HashMap<ChannelOption, Object>();
            this.childChannelConfigs = new HashMap<ChannelOption, Object>();
            this.channelConfigs.put(ChannelOption.SO_BACKLOG, 1000);
            this.sslHandlerFactory = null;
            this.exceptionHandler = new ExceptionHandler();
        }

        public Builder setAuthHandler(AuthHandler authHandler) {
            this.authHandler = authHandler;
            return this;
        }

        public Builder setChannelPipelineModifier(ChannelPipelineModifier pipelineModifier) {
            this.pipelineModifier = pipelineModifier;
            return this;
        }

        public Builder setHttpHandlers(Iterable<? extends HttpHandler> handlers) {
            this.handlers = handlers;
            return this;
        }

        public Builder setHttpHandlers(HttpHandler ... handlers) {
            return this.setHttpHandlers(Arrays.asList(handlers));
        }

        public Builder setHandlerHooks(Iterable<? extends HandlerHook> handlerHooks) {
            this.handlerHooks = handlerHooks;
            return this;
        }

        public Builder setUrlRewriter(URLRewriter urlRewriter) {
            this.urlRewriter = urlRewriter;
            return this;
        }

        public Builder setBossThreadPoolSize(int bossThreadPoolSize) {
            this.bossThreadPoolSize = bossThreadPoolSize;
            return this;
        }

        public Builder setWorkerThreadPoolSize(int workerThreadPoolSize) {
            this.workerThreadPoolSize = workerThreadPoolSize;
            return this;
        }

        public Builder setConnectionBacklog(int connectionBacklog) {
            this.channelConfigs.put(ChannelOption.SO_BACKLOG, connectionBacklog);
            return this;
        }

        public Builder setChannelConfig(ChannelOption<?> channelOption, Object value) {
            this.channelConfigs.put(channelOption, value);
            return this;
        }

        public Builder setChildChannelConfig(ChannelOption<?> channelOption, Object value) {
            this.childChannelConfigs.put(channelOption, value);
            return this;
        }

        public Builder setExecThreadPoolSize(int execThreadPoolSize) {
            this.execThreadPoolSize = execThreadPoolSize;
            return this;
        }

        public Builder setExecThreadKeepAliveSeconds(long threadKeepAliveSecs) {
            this.execThreadKeepAliveSecs = threadKeepAliveSecs;
            return this;
        }

        public Builder setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
            this.rejectedExecutionHandler = rejectedExecutionHandler;
            return this;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setHost(String host) {
            this.host = host;
            return this;
        }

        public Builder setHttpChunkLimit(int value) {
            this.httpChunkLimit = value;
            return this;
        }

        public Builder enableSSL(SSLConfig sslConfig) {
            return this.enableSSL(new SSLHandlerFactory(sslConfig));
        }

        public Builder enableSSL(SSLHandlerFactory sslHandlerFactory) {
            this.sslHandlerFactory = sslHandlerFactory;
            return this;
        }

        public Builder setExceptionHandler(ExceptionHandler exceptionHandler) {
            if (exceptionHandler == null) {
                throw new IllegalArgumentException("exceptionHandler cannot be null");
            }
            this.exceptionHandler = exceptionHandler;
            return this;
        }

        public NettyHttpService build() {
            InetSocketAddress bindAddress = this.host == null ? new InetSocketAddress("localhost", this.port) : new InetSocketAddress(this.host, this.port);
            return new NettyHttpService(this.serviceName, bindAddress, this.bossThreadPoolSize, this.workerThreadPoolSize, this.execThreadPoolSize, this.execThreadKeepAliveSecs, this.channelConfigs, this.childChannelConfigs, this.rejectedExecutionHandler, this.urlRewriter, this.handlers, this.handlerHooks, this.httpChunkLimit, this.pipelineModifier, this.sslHandlerFactory, this.exceptionHandler, this.authHandler);
        }
    }

    private static enum State {
        NOT_STARTED,
        RUNNING,
        STOPPED,
        FAILED;

    }
}

