/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http;

import io.cdap.http.ChunkResponder;
import io.cdap.http.HttpResponder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public abstract class AbstractHttpResponder
implements HttpResponder {
    protected static final String OCTET_STREAM_TYPE = "application/octet-stream";

    @Override
    public void sendJson(HttpResponseStatus status, String jsonString) {
        this.sendString(status, jsonString, new DefaultHttpHeaders().add(HttpHeaderNames.CONTENT_TYPE.toString(), (Object)"application/json"));
    }

    @Override
    public void sendString(HttpResponseStatus status, String data) {
        this.sendString(status, data, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    @Override
    public void sendString(HttpResponseStatus status, String data, HttpHeaders headers) {
        if (data == null) {
            this.sendStatus(status, headers);
            return;
        }
        ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuffer)StandardCharsets.UTF_8.encode(data));
        this.sendContent(status, buffer, this.addContentTypeIfMissing(new DefaultHttpHeaders().add(headers), "text/plain; charset=utf-8"));
    }

    @Override
    public void sendStatus(HttpResponseStatus status) {
        this.sendContent(status, Unpooled.EMPTY_BUFFER, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    @Override
    public void sendStatus(HttpResponseStatus status, HttpHeaders headers) {
        this.sendContent(status, Unpooled.EMPTY_BUFFER, headers);
    }

    @Override
    public void sendByteArray(HttpResponseStatus status, byte[] bytes, HttpHeaders headers) {
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])bytes);
        this.sendContent(status, buffer, headers);
    }

    @Override
    public void sendBytes(HttpResponseStatus status, ByteBuffer buffer, HttpHeaders headers) {
        this.sendContent(status, Unpooled.wrappedBuffer((ByteBuffer)buffer), headers);
    }

    @Override
    public void sendFile(File file) throws IOException {
        this.sendFile(file, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    @Override
    public ChunkResponder sendChunkStart(HttpResponseStatus status) {
        return this.sendChunkStart(status, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
    }

    protected final HttpHeaders addContentTypeIfMissing(HttpHeaders headers, String contentType) {
        if (!headers.contains((CharSequence)HttpHeaderNames.CONTENT_TYPE)) {
            headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        }
        return headers;
    }
}

