/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.internal.Converter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.ConvertUtils;

public final class ParamConvertUtils {
    private static final Map<Class<?>, Object> PRIMITIVE_DEFAULTS;

    public static Converter<String, Object> createPathParamConverter(final Type resultType) {
        if (!(resultType instanceof Class)) {
            throw new IllegalArgumentException("Unsupported @PathParam type " + resultType);
        }
        return new Converter<String, Object>(){

            @Override
            public Object convert(String value) {
                return ConvertUtils.convert((String)value, (Class)((Class)resultType));
            }
        };
    }

    public static Converter<List<String>, Object> createHeaderParamConverter(Type resultType) {
        return ParamConvertUtils.createListConverter(resultType);
    }

    public static Converter<List<String>, Object> createQueryParamConverter(Type resultType) {
        return ParamConvertUtils.createListConverter(resultType);
    }

    private static Converter<List<String>, Object> createListConverter(Type resultType) {
        Class<?> resultClass = ParamConvertUtils.getRawClass(resultType);
        if (resultClass == String.class) {
            return new BasicConverter(ParamConvertUtils.defaultValue(resultClass)){

                @Override
                protected Object convert(String value) throws Exception {
                    return value;
                }
            };
        }
        Converter<List<String>, Object> converter = ParamConvertUtils.createPrimitiveTypeConverter(resultClass);
        if (converter != null) {
            return converter;
        }
        converter = ParamConvertUtils.createStringConstructorConverter(resultClass);
        if (converter != null) {
            return converter;
        }
        converter = ParamConvertUtils.createStringMethodConverter(resultClass);
        if (converter != null) {
            return converter;
        }
        converter = ParamConvertUtils.createCollectionConverter(resultType);
        if (converter != null) {
            return converter;
        }
        throw new IllegalArgumentException("Unsupported type " + resultType + " of type class " + resultType.getClass());
    }

    @Nullable
    private static Converter<List<String>, Object> createPrimitiveTypeConverter(final Class<?> resultClass) {
        Object defaultValue = ParamConvertUtils.defaultValue(resultClass);
        if (defaultValue == null) {
            return null;
        }
        return new BasicConverter(defaultValue){

            @Override
            protected Object convert(String value) throws Exception {
                return ParamConvertUtils.valueOf(value, resultClass);
            }
        };
    }

    private static Converter<List<String>, Object> createStringConstructorConverter(Class<?> resultClass) {
        try {
            final Constructor<?> constructor = resultClass.getConstructor(String.class);
            return new BasicConverter(ParamConvertUtils.defaultValue(resultClass)){

                @Override
                protected Object convert(String value) throws Exception {
                    return constructor.newInstance(value);
                }
            };
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Converter<List<String>, Object> createStringMethodConverter(Class<?> resultClass) {
        Method method;
        if (resultClass == Character.class) {
            return new BasicConverter(ParamConvertUtils.defaultValue(resultClass)){

                @Override
                @Nullable
                Object convert(String value) throws Exception {
                    return value.length() >= 1 ? Character.valueOf(value.charAt(0)) : null;
                }
            };
        }
        try {
            method = resultClass.getMethod("valueOf", String.class);
        }
        catch (Exception e) {
            try {
                method = resultClass.getMethod("fromString", String.class);
            }
            catch (Exception ex) {
                return null;
            }
        }
        final Method convertMethod = method;
        return new BasicConverter(ParamConvertUtils.defaultValue(resultClass)){

            @Override
            protected Object convert(String value) throws Exception {
                return convertMethod.invoke(null, value);
            }
        };
    }

    private static Converter<List<String>, Object> createCollectionConverter(Type resultType) {
        final Class<?> rawType = ParamConvertUtils.getRawClass(resultType);
        if (rawType != List.class && rawType != Set.class && rawType != SortedSet.class) {
            return null;
        }
        if (!(resultType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType type = (ParameterizedType)resultType;
        if (type.getActualTypeArguments().length != 1) {
            return null;
        }
        Type elementType = type.getActualTypeArguments()[0];
        if (rawType == SortedSet.class && !Comparable.class.isAssignableFrom(ParamConvertUtils.getRawClass(elementType))) {
            return null;
        }
        final Converter<List<String>, Object> elementConverter = ParamConvertUtils.createQueryParamConverter(elementType);
        if (elementConverter == null) {
            return null;
        }
        return new Converter<List<String>, Object>(){

            @Override
            public Object convert(List<String> values) throws Exception {
                AbstractCollection collection = rawType == List.class ? new ArrayList() : (rawType == Set.class ? new LinkedHashSet() : new TreeSet());
                for (String value : values) {
                    this.add(collection, elementConverter.convert(Collections.singletonList(value)));
                }
                return collection;
            }

            private <T> void add(Collection<T> builder, Object element) {
                builder.add(element);
            }
        };
    }

    @Nullable
    private static Object defaultValue(Class<?> cls) {
        return PRIMITIVE_DEFAULTS.get(cls);
    }

    @Nullable
    private static Object valueOf(String value, Class<?> cls) {
        if (cls == Boolean.TYPE) {
            return Boolean.valueOf(value);
        }
        if (cls == Character.TYPE) {
            return value.length() >= 1 ? Character.valueOf(value.charAt(0)) : ParamConvertUtils.defaultValue(Character.TYPE);
        }
        if (cls == Byte.TYPE) {
            return Byte.valueOf(value);
        }
        if (cls == Short.TYPE) {
            return Short.valueOf(value);
        }
        if (cls == Integer.TYPE) {
            return Integer.valueOf(value);
        }
        if (cls == Long.TYPE) {
            return Long.valueOf(value);
        }
        if (cls == Float.TYPE) {
            return Float.valueOf(value);
        }
        if (cls == Double.TYPE) {
            return Double.valueOf(value);
        }
        return null;
    }

    private static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ParamConvertUtils.getRawClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            return ParamConvertUtils.getRawClass(((TypeVariable)type).getBounds()[0]);
        }
        if (type instanceof WildcardType) {
            return ParamConvertUtils.getRawClass(((WildcardType)type).getUpperBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            Class<?> componentClass = ParamConvertUtils.getRawClass(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(componentClass, 0).getClass();
        }
        throw new IllegalArgumentException("Unsupported type " + type + " of type class " + type.getClass());
    }

    private ParamConvertUtils() {
    }

    static {
        IdentityHashMap<Class<Comparable<Boolean>>, Comparable<Boolean>> defaults = new IdentityHashMap<Class<Comparable<Boolean>>, Comparable<Boolean>>();
        defaults.put(Boolean.TYPE, Boolean.valueOf(false));
        defaults.put(Character.TYPE, Character.valueOf('\u0000'));
        defaults.put(Byte.TYPE, Byte.valueOf((byte)0));
        defaults.put(Short.TYPE, Short.valueOf((short)0));
        defaults.put(Integer.TYPE, Integer.valueOf(0));
        defaults.put(Long.TYPE, Long.valueOf(0L));
        defaults.put(Float.TYPE, Float.valueOf(0.0f));
        defaults.put(Double.TYPE, Double.valueOf(0.0));
        PRIMITIVE_DEFAULTS = Collections.unmodifiableMap(defaults);
    }

    private static abstract class BasicConverter
    implements Converter<List<String>, Object> {
        private final Object defaultValue;

        BasicConverter(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        @Nullable
        public final Object convert(List<String> values) throws Exception {
            if (values.isEmpty()) {
                return this.getDefaultValue();
            }
            return this.convert(values.get(0));
        }

        Object getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        @Nullable
        abstract Object convert(String var1) throws Exception;
    }
}

