/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.BodyConsumer;
import io.cdap.http.ExceptionHandler;
import io.cdap.http.HandlerContext;
import io.cdap.http.HandlerHook;
import io.cdap.http.HttpHandler;
import io.cdap.http.HttpResponder;
import io.cdap.http.URLRewriter;
import io.cdap.http.internal.HandlerException;
import io.cdap.http.internal.HandlerInfo;
import io.cdap.http.internal.HttpMethodInfo;
import io.cdap.http.internal.HttpResourceModel;
import io.cdap.http.internal.PatternPathRouterWithGroups;
import io.cdap.http.internal.WrappedHttpResponder;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpResourceHandler
implements HttpHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HttpResourceHandler.class);
    private static final int MAX_PATH_PARTS = 25;
    private final PatternPathRouterWithGroups<HttpResourceModel> patternRouter = PatternPathRouterWithGroups.create(25);
    private final Iterable<HttpHandler> handlers;
    private final Iterable<HandlerHook> handlerHooks;
    private final URLRewriter urlRewriter;

    public HttpResourceHandler(Iterable<? extends HttpHandler> handlers, Iterable<? extends HandlerHook> handlerHooks, URLRewriter urlRewriter, ExceptionHandler exceptionHandler) {
        this.handlers = HttpResourceHandler.copyOf(handlers);
        this.handlerHooks = HttpResourceHandler.copyOf(handlerHooks);
        this.urlRewriter = urlRewriter;
        for (HttpHandler httpHandler : handlers) {
            LOG.trace("Parsing handler {}", (Object)httpHandler.getClass().getName());
            String basePath = "";
            if (httpHandler.getClass().isAnnotationPresent(Path.class)) {
                basePath = httpHandler.getClass().getAnnotation(Path.class).value();
            }
            for (Method method : httpHandler.getClass().getDeclaredMethods()) {
                Class<?>[] params = method.getParameterTypes();
                if (params.length >= 2 && (params[0].isAssignableFrom(HttpRequest.class) || params[0].isAssignableFrom(FullHttpRequest.class)) && params[1].isAssignableFrom(HttpResponder.class) && Modifier.isPublic(method.getModifiers())) {
                    if (BodyConsumer.class.isAssignableFrom(method.getReturnType()) && params[0].isAssignableFrom(FullHttpMessage.class)) {
                        throw new IllegalArgumentException("Method with return type as BodyConsumer cannot have FullHttpMessage as the first argument: " + method);
                    }
                    String relativePath = "";
                    if (method.getAnnotation(Path.class) != null) {
                        relativePath = method.getAnnotation(Path.class).value();
                    }
                    String absolutePath = String.format("%s/%s", basePath, relativePath);
                    Set<HttpMethod> httpMethods = this.getHttpMethods(method);
                    if (httpMethods.isEmpty()) {
                        throw new IllegalArgumentException("No HttpMethod found for handler method " + method);
                    }
                    try {
                        HttpResourceModel resourceModel = new HttpResourceModel(httpMethods, absolutePath, method, httpHandler, exceptionHandler);
                        LOG.trace("Adding resource model {}", (Object)resourceModel);
                        this.patternRouter.add(absolutePath, resourceModel);
                        continue;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to create http handler from method " + method + " in handler class " + httpHandler.getClass().getName(), e);
                    }
                }
                LOG.trace("Not adding method {}({}) to path routing like. HTTP calls will not be routed to this method", (Object)method.getName(), params);
            }
        }
    }

    private Set<HttpMethod> getHttpMethods(Method method) {
        HashSet<HttpMethod> httpMethods = new HashSet<HttpMethod>();
        if (method.isAnnotationPresent(GET.class)) {
            httpMethods.add(HttpMethod.GET);
        }
        if (method.isAnnotationPresent(PUT.class)) {
            httpMethods.add(HttpMethod.PUT);
        }
        if (method.isAnnotationPresent(POST.class)) {
            httpMethods.add(HttpMethod.POST);
        }
        if (method.isAnnotationPresent(DELETE.class)) {
            httpMethods.add(HttpMethod.DELETE);
        }
        return Collections.unmodifiableSet(httpMethods);
    }

    public void handle(HttpRequest request, HttpResponder responder) {
        if (this.urlRewriter != null) {
            try {
                request.setUri(URI.create(request.uri()).normalize().toString());
                if (!this.urlRewriter.rewrite(request, responder)) {
                    return;
                }
            }
            catch (Throwable t) {
                responder.sendString(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Caught exception processing request. Reason: %s", t.getMessage()));
                LOG.error("Exception thrown during rewriting of uri {}", (Object)request.uri(), (Object)t);
                return;
            }
        }
        try {
            String path = URI.create(request.uri()).normalize().getPath();
            List<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> routableDestinations = this.patternRouter.getDestinations(path);
            PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel> matchedDestination = this.getMatchedDestination(routableDestinations, request.method(), path);
            if (matchedDestination != null) {
                HttpResourceModel httpResourceModel = matchedDestination.getDestination();
                boolean terminated = false;
                HandlerInfo info = new HandlerInfo(httpResourceModel.getMethod().getDeclaringClass().getName(), httpResourceModel.getMethod().getName());
                for (HandlerHook hook : this.handlerHooks) {
                    if (hook.preCall(request, responder, info)) continue;
                    terminated = true;
                    break;
                }
                if (!terminated && httpResourceModel.handle(request, responder = new WrappedHttpResponder(responder, this.handlerHooks, request, info), matchedDestination.getGroupNameValues()).isStreaming()) {
                    responder.sendString(HttpResponseStatus.METHOD_NOT_ALLOWED, String.format("Body Consumer not supported for internalHttpResponder: %s", request.uri()));
                }
            } else if (routableDestinations.size() > 0) {
                responder.sendString(HttpResponseStatus.METHOD_NOT_ALLOWED, String.format("Problem accessing: %s. Reason: Method Not Allowed", request.uri()));
            } else {
                responder.sendString(HttpResponseStatus.NOT_FOUND, String.format("Problem accessing: %s. Reason: Not Found", request.uri()));
            }
        }
        catch (Throwable t) {
            responder.sendString(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Caught exception processing request. Reason: %s", t.getMessage()));
            LOG.error("Exception thrown during request processing for uri {}", (Object)request.uri(), (Object)t);
        }
    }

    @Nullable
    public HttpMethodInfo getDestinationMethod(HttpRequest request, HttpResponder responder) throws Exception {
        block11: {
            if (this.urlRewriter != null) {
                try {
                    request.setUri(URI.create(request.uri()).normalize().toString());
                    if (!this.urlRewriter.rewrite(request, responder)) {
                        return null;
                    }
                }
                catch (Throwable t) {
                    LOG.error("Exception thrown during rewriting of uri {}", (Object)request.uri(), (Object)t);
                    throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Caught exception processing request. Reason: %s", t.getMessage()));
                }
            }
            try {
                String path = URI.create(request.uri()).normalize().getPath();
                List<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> routableDestinations = this.patternRouter.getDestinations(path);
                PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel> matchedDestination = this.getMatchedDestination(routableDestinations, request.method(), path);
                if (matchedDestination != null) {
                    HttpResourceModel httpResourceModel = matchedDestination.getDestination();
                    boolean terminated = false;
                    HandlerInfo info = new HandlerInfo(httpResourceModel.getMethod().getDeclaringClass().getName(), httpResourceModel.getMethod().getName());
                    for (HandlerHook hook : this.handlerHooks) {
                        if (hook.preCall(request, responder, info)) continue;
                        terminated = true;
                        break;
                    }
                    if (!terminated) {
                        responder = new WrappedHttpResponder(responder, this.handlerHooks, request, info);
                        return httpResourceModel.handle(request, responder, matchedDestination.getGroupNameValues());
                    }
                    break block11;
                }
                if (routableDestinations.size() > 0) {
                    throw new HandlerException(HttpResponseStatus.METHOD_NOT_ALLOWED, request.uri());
                }
                throw new HandlerException(HttpResponseStatus.NOT_FOUND, String.format("Problem accessing: %s. Reason: Not Found", request.uri()));
            }
            catch (Throwable t) {
                if (t instanceof HandlerException) {
                    throw (HandlerException)t;
                }
                throw new HandlerException(HttpResponseStatus.INTERNAL_SERVER_ERROR, String.format("Caught exception processing request. Reason: %s", t.getMessage()), t);
            }
        }
        return null;
    }

    private PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel> getMatchedDestination(List<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> routableDestinations, HttpMethod targetHttpMethod, String requestUri) {
        LOG.trace("Routable destinations for request {}: {}", (Object)requestUri, routableDestinations);
        Iterable<String> requestUriParts = HttpResourceHandler.splitAndOmitEmpty(requestUri, '/');
        ArrayList<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>> matchedDestinations = new ArrayList<PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel>>();
        long maxScore = 0L;
        for (PatternPathRouterWithGroups.RoutableDestination<HttpResourceModel> destination : routableDestinations) {
            HttpResourceModel resourceModel = destination.getDestination();
            for (HttpMethod httpMethod : resourceModel.getHttpMethod()) {
                if (!targetHttpMethod.equals((Object)httpMethod)) continue;
                long score = this.getWeightedMatchScore(requestUriParts, HttpResourceHandler.splitAndOmitEmpty(resourceModel.getPath(), '/'));
                LOG.trace("Max score = {}. Weighted score for {} is {}. ", new Object[]{maxScore, destination, score});
                if (score > maxScore) {
                    maxScore = score;
                    matchedDestinations.clear();
                    matchedDestinations.add(destination);
                    continue;
                }
                if (score != maxScore) continue;
                matchedDestinations.add(destination);
            }
        }
        if (matchedDestinations.size() > 1) {
            throw new IllegalStateException(String.format("Multiple matched handlers found for request uri %s: %s", requestUri, matchedDestinations));
        }
        if (matchedDestinations.size() == 1) {
            return (PatternPathRouterWithGroups.RoutableDestination)matchedDestinations.get(0);
        }
        return null;
    }

    private long getWeightedMatchScore(Iterable<String> requestUriParts, Iterable<String> destUriParts) {
        long score = 0L;
        Iterator<String> rit = requestUriParts.iterator();
        Iterator<String> dit = destUriParts.iterator();
        while (rit.hasNext() && dit.hasNext()) {
            String destPart;
            String requestPart = rit.next();
            if (requestPart.equals(destPart = dit.next())) {
                score = score * 5L + 4L;
                continue;
            }
            if (PatternPathRouterWithGroups.GROUP_PATTERN.matcher(destPart).matches()) {
                score = score * 5L + 3L;
                continue;
            }
            score = score * 5L + 2L;
        }
        return score;
    }

    @Override
    public void init(HandlerContext context) {
        for (HttpHandler handler : this.handlers) {
            handler.init(context);
        }
    }

    @Override
    public void destroy(HandlerContext context) {
        for (HttpHandler handler : this.handlers) {
            try {
                handler.destroy(context);
            }
            catch (Throwable t) {
                LOG.warn("Exception raised in calling handler.destroy() for handler {}", (Object)handler, (Object)t);
            }
        }
    }

    private static <T> List<T> copyOf(Iterable<? extends T> iterable) {
        ArrayList<T> list = new ArrayList<T>();
        for (T item : iterable) {
            list.add(item);
        }
        return Collections.unmodifiableList(list);
    }

    private static Iterable<String> splitAndOmitEmpty(final String str, final char splitChar) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    int startIdx = 0;
                    String next = null;

                    @Override
                    public boolean hasNext() {
                        while (this.next == null && this.startIdx < str.length()) {
                            int idx = str.indexOf(splitChar, this.startIdx);
                            if (idx == this.startIdx) {
                                ++this.startIdx;
                                continue;
                            }
                            if (idx >= 0) {
                                this.next = str.substring(this.startIdx, idx);
                                this.startIdx = idx;
                                continue;
                            }
                            if (this.startIdx >= str.length()) break;
                            this.next = str.substring(this.startIdx);
                            this.startIdx = str.length();
                            break;
                        }
                        return this.next != null;
                    }

                    @Override
                    public String next() {
                        if (this.hasNext()) {
                            String next = this.next;
                            this.next = null;
                            return next;
                        }
                        throw new NoSuchElementException("No more element");
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove not supported");
                    }
                };
            }
        };
    }
}

