/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.BodyConsumer;
import io.cdap.http.ExceptionHandler;
import io.cdap.http.HttpHandler;
import io.cdap.http.HttpResponder;
import io.cdap.http.internal.HandlerException;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpMethodInfo {
    private static final Logger LOG = LoggerFactory.getLogger(HttpMethodInfo.class);
    private final Method method;
    private final HttpHandler handler;
    private final HttpResponder responder;
    private final Object[] args;
    private final boolean isStreaming;
    private final ExceptionHandler exceptionHandler;
    private HttpRequest request;
    private BodyConsumer bodyConsumer;

    HttpMethodInfo(Method method, HttpHandler handler, HttpResponder responder, Object[] args, ExceptionHandler exceptionHandler) {
        this.method = method;
        this.handler = handler;
        this.isStreaming = BodyConsumer.class.isAssignableFrom(method.getReturnType());
        this.responder = responder;
        this.exceptionHandler = exceptionHandler;
        this.args = new Object[args.length + 2];
        this.args[0] = null;
        this.args[1] = responder;
        System.arraycopy(args, 0, this.args, 2, args.length);
    }

    void invoke(HttpRequest request) throws Exception {
        Object invokeResult;
        this.bodyConsumer = null;
        try {
            this.request = request;
            this.args[0] = this.request;
            invokeResult = this.method.invoke((Object)this.handler, this.args);
        }
        catch (InvocationTargetException e) {
            this.exceptionHandler.handle(e.getTargetException(), request, this.responder);
            return;
        }
        catch (Throwable t) {
            this.exceptionHandler.handle(t, request, this.responder);
            return;
        }
        if (this.isStreaming) {
            this.bodyConsumer = (BodyConsumer)invokeResult;
        }
    }

    void chunk(HttpContent chunk) throws Exception {
        if (this.bodyConsumer == null) {
            return;
        }
        if (chunk.content().isReadable()) {
            this.bodyConsumerChunk(chunk.content());
        }
        if (chunk instanceof LastHttpContent) {
            this.bodyConsumerFinish();
        }
    }

    void disconnected() {
        if (this.bodyConsumer != null) {
            this.bodyConsumerError(new ClosedChannelException());
        }
    }

    private void bodyConsumerChunk(ByteBuf buffer) throws HandlerException {
        try {
            this.bodyConsumer.chunk(buffer, this.responder);
        }
        catch (Throwable t) {
            try {
                this.bodyConsumerError(t);
            }
            catch (Throwable t2) {
                this.exceptionHandler.handle(t2, this.request, this.responder);
                LOG.debug("Handled exception thrown from handleError. original exception from chunk call was:", t);
                return;
            }
            this.exceptionHandler.handle(t, this.request, this.responder);
        }
    }

    private void bodyConsumerFinish() {
        BodyConsumer consumer = this.bodyConsumer;
        this.bodyConsumer = null;
        try {
            consumer.finished(this.responder);
        }
        catch (Throwable t) {
            this.exceptionHandler.handle(t, this.request, this.responder);
        }
    }

    private void bodyConsumerError(Throwable cause) {
        BodyConsumer consumer = this.bodyConsumer;
        this.bodyConsumer = null;
        consumer.handleError(cause);
    }

    void sendError(HttpResponseStatus status, Throwable ex) {
        String msg = ex instanceof InvocationTargetException ? String.format("Exception Encountered while processing request : %s", ex.getCause().getMessage()) : String.format("Exception Encountered while processing request: %s", ex.getMessage());
        this.responder.sendString(status, msg, new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE));
        if (this.bodyConsumer != null) {
            this.bodyConsumerError(ex);
        }
    }

    boolean isStreaming() {
        return this.isStreaming;
    }
}

