/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.cdap.http.internal.HttpMethodInfo;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;

public class HttpDispatcher
extends ChannelInboundHandlerAdapter {
    public static final AttributeKey<HttpMethodInfo> METHOD_INFO_KEY = AttributeKey.newInstance((String)"methodInfo");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpMethodInfo methodInfo = (HttpMethodInfo)ctx.channel().attr(METHOD_INFO_KEY).get();
        try {
            if (methodInfo == null) {
                throw new IllegalStateException("No handler dispatch information available");
            }
            if (msg instanceof HttpRequest) {
                methodInfo.invoke((HttpRequest)msg);
            } else if (msg instanceof HttpContent) {
                methodInfo.chunk((HttpContent)msg);
            } else {
                ReferenceCountUtil.retain((Object)msg);
                ctx.fireChannelRead(msg);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        HttpMethodInfo methodInfo = (HttpMethodInfo)ctx.channel().attr(METHOD_INFO_KEY).getAndSet(null);
        if (methodInfo != null) {
            methodInfo.disconnected();
        }
    }
}

