/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http;

import io.cdap.http.SSLConfig;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;

public class SSLHandlerFactory {
    private final SslContext sslContext;
    private boolean needClientAuth;

    public SSLHandlerFactory(SSLConfig sslConfig) {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore ks = SSLHandlerFactory.getKeyStore(sslConfig.getKeyStore(), sslConfig.getKeyStorePassword());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, sslConfig.getCertificatePassword() != null ? sslConfig.getCertificatePassword().toCharArray() : sslConfig.getKeyStorePassword().toCharArray());
            SslContextBuilder builder = SslContextBuilder.forServer((KeyManagerFactory)kmf);
            if (sslConfig.getTrustKeyStore() != null) {
                this.needClientAuth = true;
                KeyStore tks = SSLHandlerFactory.getKeyStore(sslConfig.getTrustKeyStore(), sslConfig.getTrustKeyStorePassword());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
                tmf.init(tks);
                builder.trustManager(tmf);
            }
            this.sslContext = builder.build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to initialize the server-side SSLContext", e);
        }
    }

    public SSLHandlerFactory(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    private static KeyStore getKeyStore(File keyStore, String keyStorePassword) throws Exception {
        try (FileInputStream is = new FileInputStream(keyStore);){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(is, keyStorePassword.toCharArray());
            KeyStore keyStore2 = ks;
            return keyStore2;
        }
    }

    public SslHandler create(ByteBufAllocator bufferAllocator) {
        SSLEngine engine = this.sslContext.newEngine(bufferAllocator);
        engine.setNeedClientAuth(this.needClientAuth);
        engine.setUseClientMode(false);
        return new SslHandler(engine);
    }
}

