/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.http.internal;

import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.OrderedEventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public final class NonStickyEventExecutorGroup
implements EventExecutorGroup {
    private final EventExecutorGroup group;
    private final int maxTaskExecutePerRun;

    public NonStickyEventExecutorGroup(EventExecutorGroup group) {
        this(group, 1024);
    }

    public NonStickyEventExecutorGroup(EventExecutorGroup group, int maxTaskExecutePerRun) {
        this.group = NonStickyEventExecutorGroup.verify(group);
        this.maxTaskExecutePerRun = ObjectUtil.checkPositive((int)maxTaskExecutePerRun, (String)"maxTaskExecutePerRun");
    }

    private static EventExecutorGroup verify(EventExecutorGroup group) {
        for (EventExecutor executor : (EventExecutorGroup)ObjectUtil.checkNotNull((Object)group, (String)"group")) {
            if (!(executor instanceof OrderedEventExecutor)) continue;
            throw new IllegalArgumentException("EventExecutorGroup " + group + " contains OrderedEventExecutors: " + executor);
        }
        return group;
    }

    private NonStickyOrderedEventExecutor newExecutor(EventExecutor executor) {
        return new NonStickyOrderedEventExecutor(executor, this.maxTaskExecutePerRun);
    }

    public boolean isShuttingDown() {
        return this.group.isShuttingDown();
    }

    public Future<?> shutdownGracefully() {
        return this.group.shutdownGracefully();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.group.shutdownGracefully(quietPeriod, timeout, unit);
    }

    public Future<?> terminationFuture() {
        return this.group.terminationFuture();
    }

    public void shutdown() {
        this.group.shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.group.shutdownNow();
    }

    public EventExecutor next() {
        return this.newExecutor(this.group.next());
    }

    public Iterator<EventExecutor> iterator() {
        final Iterator itr = this.group.iterator();
        return new Iterator<EventExecutor>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public EventExecutor next() {
                return NonStickyEventExecutorGroup.this.newExecutor((EventExecutor)itr.next());
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }

    public Future<?> submit(Runnable task) {
        return this.group.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.group.submit(task, result);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.group.submit(task);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.group.schedule(command, delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.group.schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.group.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.group.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public boolean isShutdown() {
        return this.group.isShutdown();
    }

    public boolean isTerminated() {
        return this.group.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.group.awaitTermination(timeout, unit);
    }

    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.group.invokeAll(tasks);
    }

    public <T> List<java.util.concurrent.Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.group.invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.group.invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.group.invokeAny(tasks, timeout, unit);
    }

    public void execute(Runnable command) {
        this.group.execute(command);
    }

    private static final class NonStickyOrderedEventExecutor
    extends AbstractEventExecutor
    implements Runnable,
    OrderedEventExecutor {
        private final EventExecutor executor;
        private final Queue<Runnable> tasks = PlatformDependent.newMpscQueue();
        private static final int NONE = 0;
        private static final int SUBMITTED = 1;
        private static final int RUNNING = 2;
        private final AtomicInteger state = new AtomicInteger();
        private final int maxTaskExecutePerRun;

        NonStickyOrderedEventExecutor(EventExecutor executor, int maxTaskExecutePerRun) {
            super((EventExecutorGroup)executor);
            this.executor = executor;
            this.maxTaskExecutePerRun = maxTaskExecutePerRun;
        }

        @Override
        public void run() {
            if (!this.state.compareAndSet(1, 2)) {
                return;
            }
            block7: while (true) {
                int i = 0;
                try {
                    while (true) {
                        Runnable task;
                        if (i >= this.maxTaskExecutePerRun || (task = this.tasks.poll()) == null) continue block7;
                        NonStickyOrderedEventExecutor.safeExecute((Runnable)task);
                        ++i;
                    }
                }
                finally {
                    if (i == this.maxTaskExecutePerRun) {
                        try {
                            this.state.set(1);
                            this.executor.execute((Runnable)this);
                            return;
                        }
                        catch (Throwable ignore) {
                            this.state.set(2);
                        }
                    } else {
                        this.state.set(0);
                        if (this.tasks.peek() != null && this.state.compareAndSet(0, 2)) continue;
                        return;
                    }
                    continue;
                }
                break;
            }
        }

        public boolean inEventLoop(Thread thread) {
            return false;
        }

        public boolean inEventLoop() {
            return false;
        }

        public boolean isShuttingDown() {
            return this.executor.isShutdown();
        }

        public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
            return this.executor.shutdownGracefully(quietPeriod, timeout, unit);
        }

        public Future<?> terminationFuture() {
            return this.executor.terminationFuture();
        }

        public void shutdown() {
            this.executor.shutdown();
        }

        public boolean isShutdown() {
            return this.executor.isShutdown();
        }

        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.awaitTermination(timeout, unit);
        }

        public void execute(Runnable command) {
            if (!this.tasks.offer(command)) {
                throw new RejectedExecutionException();
            }
            if (this.state.compareAndSet(0, 1)) {
                try {
                    this.executor.execute((Runnable)this);
                }
                catch (Throwable e) {
                    this.tasks.remove(command);
                    PlatformDependent.throwException((Throwable)e);
                }
            }
        }
    }
}

