/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.test.mock;

import io.cdap.delta.api.ChangeEvent;
import io.cdap.delta.api.DDLEvent;
import io.cdap.delta.api.DMLEvent;
import io.cdap.delta.api.EventEmitter;
import io.cdap.delta.api.EventReader;
import io.cdap.delta.api.Offset;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;

public class MockEventReader
implements EventReader {
    private final List<? extends ChangeEvent> events;
    private final EventEmitter emitter;
    private final int maxEvents;
    private final ExecutorService executorService;
    private final AtomicBoolean shouldStop;
    private int numEvents;

    public MockEventReader(List<? extends ChangeEvent> events, EventEmitter emitter, int maxEvents) {
        this.events = events;
        this.emitter = emitter;
        this.maxEvents = maxEvents;
        this.numEvents = 0;
        this.executorService = Executors.newSingleThreadExecutor();
        this.shouldStop = new AtomicBoolean(false);
    }

    public void start(Offset offset) {
        Iterator<? extends ChangeEvent> eventIter = this.events.iterator();
        if (!offset.get().isEmpty()) {
            while (eventIter.hasNext() && !offset.equals((Object)eventIter.next().getOffset())) {
            }
        }
        this.executorService.submit(() -> {
            while (!this.shouldStop.get() && eventIter.hasNext() && this.numEvents < this.maxEvents) {
                ++this.numEvents;
                ChangeEvent event = (ChangeEvent)eventIter.next();
                try {
                    if (event instanceof DDLEvent) {
                        this.emitter.emit((DDLEvent)event);
                        continue;
                    }
                    if (!(event instanceof DMLEvent)) continue;
                    this.emitter.emit((DMLEvent)event);
                }
                catch (InterruptedException e) {
                    this.shouldStop.set(true);
                }
            }
        });
    }

    public void stop() {
        this.shouldStop.set(true);
    }
}

