/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.delta.test.mock;

import com.google.gson.Gson;
import io.cdap.cdap.api.Config;
import io.cdap.cdap.api.app.ApplicationConfigUpdateAction;
import io.cdap.cdap.api.app.ApplicationUpdateContext;
import io.cdap.cdap.api.artifact.ArtifactId;
import io.cdap.cdap.api.artifact.ArtifactScope;
import io.cdap.cdap.api.artifact.ArtifactVersion;
import io.cdap.cdap.api.artifact.ArtifactVersionRange;
import io.cdap.delta.proto.Artifact;
import io.cdap.delta.proto.DeltaConfig;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class MockApplicationUpdateContext
implements ApplicationUpdateContext {
    private final Gson gson = new Gson();
    private final DeltaConfig originalConfig;
    private final Artifact newSource;
    private final Artifact newTarget;

    public MockApplicationUpdateContext(DeltaConfig originalConfig, Artifact newSource, Artifact newTarget) {
        this.originalConfig = originalConfig;
        this.newSource = newSource;
        this.newTarget = newTarget;
    }

    public List<ApplicationConfigUpdateAction> getUpdateActions() {
        return Collections.singletonList(ApplicationConfigUpdateAction.UPGRADE_ARTIFACT);
    }

    public <C extends Config> C getConfig(Type type) {
        return (C)this.originalConfig;
    }

    public String getConfigAsString() {
        return this.gson.toJson((Object)this.originalConfig);
    }

    public List<ArtifactId> getPluginArtifacts(String pluginType, String pluginName, @Nullable ArtifactVersionRange pluginRange, int limit) throws Exception {
        if (pluginType.equals("cdcSource")) {
            return Collections.singletonList(new ArtifactId(this.newSource.getName(), new ArtifactVersion(this.newSource.getVersion()), ArtifactScope.valueOf((String)this.newSource.getScope())));
        }
        return Collections.singletonList(new ArtifactId(this.newTarget.getName(), new ArtifactVersion(this.newTarget.getVersion()), ArtifactScope.valueOf((String)this.newTarget.getScope())));
    }
}

