/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.io;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executor;

public final class AsyncFunctions {
    public static <I, O> AsyncFunction<I, O> asyncWrap(final Function<I, O> function, final Executor executor) {
        return new AsyncFunction<I, O>(){

            public ListenableFuture<O> apply(final I input) throws Exception {
                final SettableFuture resultFuture = SettableFuture.create();
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            resultFuture.set(function.apply(input));
                        }
                        catch (Throwable t) {
                            resultFuture.setException(t);
                        }
                    }
                });
                return resultFuture;
            }
        };
    }

    public static <I, O> AsyncFunction<I, O> asyncWrap(final Function<I, O> function) {
        return new AsyncFunction<I, O>(){

            public ListenableFuture<O> apply(I input) throws Exception {
                return Futures.immediateFuture((Object)function.apply(input));
            }
        };
    }

    private AsyncFunctions() {
    }
}

