/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.internal.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.io.CharStreams;
import com.google.gson.stream.JsonWriter;
import io.cdap.common.internal.io.SchemaHash;
import io.cdap.common.internal.io.SchemaTypeAdapter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Schema {
    private final Type type;
    private final BiMap<String, Integer> enumValues;
    private final BiMap<Integer, String> enumIndexes;
    private final Schema componentSchema;
    private final Schema keySchema;
    private final Schema valueSchema;
    private final Map.Entry<Schema, Schema> mapSchema;
    private final String recordName;
    private final Map<String, Field> fieldMap;
    private final List<Field> fields;
    private final List<Schema> unionSchemas;
    private String schemaString;
    private SchemaHash schemaHash;

    public static Schema of(Type type) {
        Preconditions.checkArgument((boolean)type.isSimpleType(), (String)"Type %s is not a simple type.", (Object[])new Object[]{type});
        return new Schema(type, null, null, null, null, null, null, null);
    }

    public static Schema enumWith(String ... values) {
        return Schema.enumWith((Iterable<String>)ImmutableList.copyOf((Object[])values));
    }

    public static Schema enumWith(Iterable<String> values) {
        ImmutableSet uniqueValues = ImmutableSet.copyOf(values);
        Preconditions.checkArgument((uniqueValues.size() > 0 ? 1 : 0) != 0, (Object)"No enum value provided.");
        Preconditions.checkArgument((Iterables.size(values) == uniqueValues.size() ? 1 : 0) != 0, (Object)"Duplicate enum value is not allowed.");
        return new Schema(Type.ENUM, (Set<String>)uniqueValues, null, null, null, null, null, null);
    }

    public static Schema enumWith(Class<Enum<?>> enumClass) {
        Enum<?>[] enumConstants = enumClass.getEnumConstants();
        String[] names = new String[enumConstants.length];
        for (int i = 0; i < enumConstants.length; ++i) {
            names[i] = enumConstants[i].name();
        }
        return Schema.enumWith(names);
    }

    public static Schema arrayOf(Schema componentSchema) {
        return new Schema(Type.ARRAY, null, componentSchema, null, null, null, null, null);
    }

    public static Schema mapOf(Schema keySchema, Schema valueSchema) {
        return new Schema(Type.MAP, null, null, keySchema, valueSchema, null, null, null);
    }

    public static Schema recordOf(String name) {
        Preconditions.checkNotNull((Object)name, (Object)"Record name cannot be null.");
        return new Schema(Type.RECORD, null, null, null, null, name, null, null);
    }

    public static Schema recordOf(String name, Field ... fields) {
        return Schema.recordOf(name, (Iterable<Field>)ImmutableList.copyOf((Object[])fields));
    }

    public static Schema recordOf(String name, Iterable<Field> fields) {
        Preconditions.checkNotNull((Object)name, (Object)"Record name cannot be null.");
        ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
        for (Field field : fields) {
            fieldMapBuilder.put((Object)field.getName(), (Object)field);
        }
        ImmutableMap fieldMap = fieldMapBuilder.build();
        Preconditions.checkArgument((fieldMap.size() > 0 ? 1 : 0) != 0, (String)"No record field provided for %s", (Object[])new Object[]{name});
        return new Schema(Type.RECORD, null, null, null, null, name, (Map<String, Field>)fieldMap, null);
    }

    public static Schema unionOf(Schema ... schemas) {
        return Schema.unionOf((Iterable<Schema>)ImmutableList.copyOf((Object[])schemas));
    }

    public static Schema unionOf(Iterable<Schema> schemas) {
        ImmutableList schemaList = ImmutableList.copyOf(schemas);
        Preconditions.checkArgument((schemaList.size() > 0 ? 1 : 0) != 0, (Object)"No union schema provided.");
        return new Schema(Type.UNION, null, null, null, null, null, null, (List<Schema>)schemaList);
    }

    private Schema(Type type, Set<String> enumValues, Schema componentSchema, Schema keySchema, Schema valueSchema, String recordName, Map<String, Field> fieldMap, List<Schema> unionSchemas) {
        this.type = type;
        this.enumValues = this.createIndex(enumValues);
        this.enumIndexes = this.enumValues == null ? null : this.enumValues.inverse();
        this.componentSchema = componentSchema;
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.mapSchema = keySchema == null || valueSchema == null ? null : Maps.immutableEntry((Object)keySchema, (Object)valueSchema);
        this.recordName = recordName;
        this.fieldMap = this.populateRecordFields(fieldMap);
        this.fields = this.fieldMap == null ? null : ImmutableList.copyOf(this.fieldMap.values());
        this.unionSchemas = unionSchemas;
    }

    public Type getType() {
        return this.type;
    }

    public Set<String> getEnumValues() {
        return this.enumValues.keySet();
    }

    public int getEnumIndex(String value) {
        if (this.enumValues == null) {
            return -1;
        }
        Integer idx = (Integer)this.enumValues.get((Object)value);
        return idx == null ? -1 : idx;
    }

    public String getEnumValue(int idx) {
        if (this.enumIndexes == null) {
            return null;
        }
        return (String)this.enumIndexes.get((Object)idx);
    }

    public Schema getComponentSchema() {
        return this.componentSchema;
    }

    public Map.Entry<Schema, Schema> getMapSchema() {
        return this.mapSchema;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public Field getField(String name) {
        if (this.fieldMap == null) {
            return null;
        }
        return this.fieldMap.get(name);
    }

    public List<Schema> getUnionSchemas() {
        return this.unionSchemas;
    }

    public Schema getUnionSchema(int idx) {
        return this.unionSchemas == null || idx < 0 || this.unionSchemas.size() <= idx ? null : this.unionSchemas.get(idx);
    }

    public String toString() {
        String str = this.schemaString;
        if (str == null) {
            this.schemaString = str = this.buildString();
        }
        return str;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.getSchemaHash().equals(((Schema)other).getSchemaHash());
    }

    public int hashCode() {
        return this.getSchemaHash().hashCode();
    }

    public SchemaHash getSchemaHash() {
        SchemaHash hash = this.schemaHash;
        if (hash == null) {
            this.schemaHash = hash = new SchemaHash(this);
        }
        return hash;
    }

    public boolean isCompatible(Schema target) {
        if (this.equals(target)) {
            return true;
        }
        HashMultimap recordCompared = HashMultimap.create();
        return this.checkCompatible(target, (Multimap<String, String>)recordCompared);
    }

    private boolean checkCompatible(Schema target, Multimap<String, String> recordCompared) {
        if (this.type.isSimpleType()) {
            if (this.type == target.getType()) {
                return true;
            }
            switch (target.getType()) {
                case LONG: {
                    return this.type == Type.INT;
                }
                case FLOAT: {
                    return this.type == Type.INT || this.type == Type.LONG;
                }
                case DOUBLE: {
                    return this.type == Type.INT || this.type == Type.LONG || this.type == Type.FLOAT;
                }
                case STRING: {
                    return this.type != Type.NULL && this.type != Type.BYTES;
                }
                case UNION: {
                    for (Schema targetSchema : target.unionSchemas) {
                        if (!this.checkCompatible(targetSchema, recordCompared)) continue;
                        return true;
                    }
                    break;
                }
            }
            return false;
        }
        if (this.type == target.type) {
            switch (this.type) {
                case ENUM: {
                    return target.getEnumValues().containsAll(this.getEnumValues());
                }
                case ARRAY: {
                    return this.componentSchema.checkCompatible(target.getComponentSchema(), recordCompared);
                }
                case MAP: {
                    return this.keySchema.checkCompatible(target.keySchema, recordCompared) && this.valueSchema.checkCompatible(target.valueSchema, recordCompared);
                }
                case RECORD: {
                    if (!recordCompared.containsEntry((Object)this.recordName, (Object)target.recordName)) {
                        recordCompared.put((Object)this.recordName, (Object)target.recordName);
                        for (Field field : this.fields) {
                            Field targetField = target.getField(field.getName());
                            if (targetField == null || field.getSchema().checkCompatible(targetField.getSchema(), recordCompared)) continue;
                            return false;
                        }
                    }
                    return true;
                }
                case UNION: {
                    for (Schema sourceSchema : this.unionSchemas) {
                        for (Schema targetSchema : target.unionSchemas) {
                            if (!sourceSchema.checkCompatible(targetSchema, recordCompared)) continue;
                            return true;
                        }
                    }
                    return false;
                }
            }
        }
        if (this.type == Type.UNION || target.type == Type.UNION) {
            List<Schema> unions = this.type == Type.UNION ? this.unionSchemas : target.unionSchemas;
            Schema checkSchema = this.type == Type.UNION ? target : this;
            for (Schema schema : unions) {
                if (!schema.checkCompatible(checkSchema, recordCompared)) continue;
                return true;
            }
        }
        return false;
    }

    private <V> BiMap<V, Integer> createIndex(Set<V> values) {
        if (values == null) {
            return null;
        }
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        int idx = 0;
        for (V value : values) {
            builder.put(value, (Object)idx++);
        }
        return builder.build();
    }

    private Map<String, Field> populateRecordFields(Map<String, Field> fields) {
        if (fields == null) {
            return null;
        }
        HashMap knownRecordSchemas = Maps.newHashMap();
        knownRecordSchemas.put(this.recordName, this);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, Field> fieldEntry : fields.entrySet()) {
            String fieldName = fieldEntry.getKey();
            Field field = fieldEntry.getValue();
            Schema fieldSchema = this.resolveSchema(field.getSchema(), knownRecordSchemas);
            if (fieldSchema == field.getSchema()) {
                builder.put((Object)fieldName, (Object)field);
                continue;
            }
            builder.put((Object)fieldName, (Object)Field.of(fieldName, fieldSchema));
        }
        return builder.build();
    }

    private Schema resolveSchema(Schema schema, Map<String, Schema> knownRecordSchemas) {
        switch (schema.getType()) {
            case ARRAY: {
                Schema componentSchema = this.resolveSchema(schema.getComponentSchema(), knownRecordSchemas);
                return componentSchema == schema.getComponentSchema() ? schema : Schema.arrayOf(componentSchema);
            }
            case MAP: {
                Map.Entry<Schema, Schema> entry = schema.getMapSchema();
                Schema keySchema = this.resolveSchema(entry.getKey(), knownRecordSchemas);
                Schema valueSchema = this.resolveSchema(entry.getValue(), knownRecordSchemas);
                return keySchema == entry.getKey() && valueSchema == entry.getValue() ? schema : Schema.mapOf(keySchema, valueSchema);
            }
            case UNION: {
                ImmutableList.Builder schemaBuilder = ImmutableList.builder();
                boolean changed = false;
                for (Schema input : schema.getUnionSchemas()) {
                    Schema output = this.resolveSchema(input, knownRecordSchemas);
                    if (output != input) {
                        changed = true;
                    }
                    schemaBuilder.add((Object)output);
                }
                return changed ? Schema.unionOf((Iterable<Schema>)schemaBuilder.build()) : schema;
            }
            case RECORD: {
                if (schema.fields == null) {
                    Schema knownSchema = knownRecordSchemas.get(schema.recordName);
                    Preconditions.checkArgument((knownSchema != null ? 1 : 0) != 0, (String)"Undefined schema %s", (Object[])new Object[]{schema.recordName});
                    return knownSchema;
                }
                knownRecordSchemas.put(schema.recordName, schema);
                return schema;
            }
        }
        return schema;
    }

    private String buildString() {
        if (this.type.isSimpleType()) {
            return '\"' + this.type.name().toLowerCase() + '\"';
        }
        StringBuilder builder = new StringBuilder();
        JsonWriter writer = new JsonWriter(CharStreams.asWriter((Appendable)builder));
        try {
            new SchemaTypeAdapter().write(writer, this);
            writer.close();
            return builder.toString();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static final class Field {
        private final String name;
        private final Schema schema;

        public static Field of(String name, Schema schema) {
            return new Field(name, schema);
        }

        private Field(String name, Schema schema) {
            this.name = name;
            this.schema = schema;
        }

        public String getName() {
            return this.name;
        }

        public Schema getSchema() {
            return this.schema;
        }
    }

    public static enum Type {
        NULL(true),
        BOOLEAN(true),
        INT(true),
        LONG(true),
        FLOAT(true),
        DOUBLE(true),
        BYTES(true),
        STRING(true),
        ENUM(false),
        ARRAY(false),
        MAP(false),
        RECORD(false),
        UNION(false);

        private final boolean simpleType;

        private Type(boolean primitive) {
            this.simpleType = primitive;
        }

        public boolean isSimpleType() {
            return this.simpleType;
        }
    }
}

