/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.internal.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import io.cdap.common.internal.io.AbstractSchemaGenerator;
import io.cdap.common.internal.io.Schema;
import io.cdap.common.internal.io.UnsupportedTypeException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public final class ReflectionSchemaGenerator
extends AbstractSchemaGenerator {
    @Override
    protected Schema generateRecord(TypeToken<?> typeToken, Set<String> knowRecords, boolean acceptRecursion) throws UnsupportedTypeException {
        String recordName = typeToken.getRawType().getName();
        Map<String, TypeToken<?>> recordFieldTypes = typeToken.getRawType().isInterface() ? this.collectByMethods(typeToken, Maps.newTreeMap()) : this.collectByFields(typeToken, Maps.newTreeMap());
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<String, TypeToken<?>> fieldType : recordFieldTypes.entrySet()) {
            Schema fieldSchema = this.doGenerate(fieldType.getValue(), (Set<String>)ImmutableSet.builder().addAll(knowRecords).add((Object)recordName).build(), acceptRecursion);
            if (!fieldType.getValue().getRawType().isPrimitive() && !typeToken.getRawType().isAnnotationPresent(Nonnull.class)) {
                fieldSchema = Schema.unionOf(fieldSchema, Schema.of(Schema.Type.NULL));
            }
            builder.add((Object)Schema.Field.of(fieldType.getKey(), fieldSchema));
        }
        return Schema.recordOf(recordName, (Iterable<Schema.Field>)builder.build());
    }

    private Map<String, TypeToken<?>> collectByFields(TypeToken<?> typeToken, Map<String, TypeToken<?>> fieldTypes) {
        for (TypeToken classType : typeToken.getTypes().classes()) {
            Class rawType = classType.getRawType();
            if (rawType.equals(Object.class)) continue;
            for (Field field : rawType.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || field.isSynthetic()) continue;
                TypeToken fieldType = classType.resolveType(field.getGenericType());
                fieldTypes.put(field.getName(), fieldType);
            }
        }
        return fieldTypes;
    }

    private Map<String, TypeToken<?>> collectByMethods(TypeToken<?> typeToken, Map<String, TypeToken<?>> fieldTypes) {
        for (Method method : typeToken.getRawType().getMethods()) {
            String fieldName;
            String methodName;
            if (method.getDeclaringClass().equals(Object.class) || !(methodName = method.getName()).startsWith("get") && !methodName.startsWith("is") || method.isSynthetic() || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
            String string = fieldName = methodName.startsWith("get") ? methodName.substring("get".length()) : methodName.substring("is".length());
            if (fieldName.isEmpty() || fieldTypes.containsKey(fieldName = String.format("%c%s", Character.valueOf(Character.toLowerCase(fieldName.charAt(0))), fieldName.substring(1)))) continue;
            TypeToken fieldType = typeToken.resolveType(method.getGenericReturnType());
            fieldTypes.put(fieldName, fieldType);
        }
        return fieldTypes;
    }
}

