/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buffer;

    public ByteBufferInputStream(ByteBuffer buffer) {
        this.reset(buffer);
    }

    public ByteBufferInputStream reset(ByteBuffer buffer) {
        this.buffer = buffer;
        return this;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.remaining() <= 0) {
            return -1;
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int remaining = this.buffer.remaining();
        if (remaining <= 0) {
            return -1;
        }
        if (len <= remaining) {
            this.buffer.get(b, off, len);
            return len;
        }
        this.buffer.get(b, off, remaining);
        return remaining;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            throw new IOException("Cannot skip more then " + n + " bytes.");
        }
        int skips = (int)n;
        if (skips > this.buffer.remaining()) {
            skips = this.buffer.remaining();
        }
        this.buffer.position(this.buffer.position() + skips);
        return skips;
    }
}

