/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.internal.io;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import io.cdap.common.internal.io.Schema;
import io.cdap.common.internal.io.SchemaGenerator;
import io.cdap.common.internal.io.UnsupportedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSchemaGenerator
implements SchemaGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSchemaGenerator.class);
    private static final Map<Class<?>, Schema> SIMPLE_SCHEMAS = ImmutableMap.builder().put(Boolean.TYPE, (Object)Schema.of(Schema.Type.BOOLEAN)).put(Byte.TYPE, (Object)Schema.of(Schema.Type.INT)).put(Character.TYPE, (Object)Schema.of(Schema.Type.INT)).put(Short.TYPE, (Object)Schema.of(Schema.Type.INT)).put(Integer.TYPE, (Object)Schema.of(Schema.Type.INT)).put(Long.TYPE, (Object)Schema.of(Schema.Type.LONG)).put(Float.TYPE, (Object)Schema.of(Schema.Type.FLOAT)).put(Double.TYPE, (Object)Schema.of(Schema.Type.DOUBLE)).put(Boolean.class, (Object)Schema.of(Schema.Type.BOOLEAN)).put(Byte.class, (Object)Schema.of(Schema.Type.INT)).put(Character.class, (Object)Schema.of(Schema.Type.INT)).put(Short.class, (Object)Schema.of(Schema.Type.INT)).put(Integer.class, (Object)Schema.of(Schema.Type.INT)).put(Long.class, (Object)Schema.of(Schema.Type.LONG)).put(Float.class, (Object)Schema.of(Schema.Type.FLOAT)).put(Double.class, (Object)Schema.of(Schema.Type.DOUBLE)).put(String.class, (Object)Schema.of(Schema.Type.STRING)).put(byte[].class, (Object)Schema.of(Schema.Type.BYTES)).put(ByteBuffer.class, (Object)Schema.of(Schema.Type.BYTES)).put(URI.class, (Object)Schema.of(Schema.Type.STRING)).put(URL.class, (Object)Schema.of(Schema.Type.STRING)).put(UUID.class, (Object)Schema.of(Schema.Type.BYTES)).build();

    @Override
    public final Schema generate(Type type) throws UnsupportedTypeException {
        return this.generate(type, true);
    }

    @Override
    public final Schema generate(Type type, boolean acceptRecursiveTypes) throws UnsupportedTypeException {
        ImmutableSet knownRecords = ImmutableSet.of();
        return this.doGenerate(TypeToken.of((Type)type), (Set<String>)knownRecords, acceptRecursiveTypes);
    }

    protected final Schema doGenerate(TypeToken<?> typeToken, Set<String> knownRecords, boolean acceptRecursion) throws UnsupportedTypeException {
        Type type = typeToken.getType();
        Class rawType = typeToken.getRawType();
        if (SIMPLE_SCHEMAS.containsKey(rawType)) {
            return SIMPLE_SCHEMAS.get(rawType);
        }
        if (rawType.isEnum()) {
            return Schema.enumWith(rawType);
        }
        if (rawType.isArray()) {
            Schema componentSchema = this.doGenerate(TypeToken.of(rawType.getComponentType()), knownRecords, acceptRecursion);
            if (rawType.getComponentType().isPrimitive()) {
                return Schema.arrayOf(componentSchema);
            }
            return Schema.arrayOf(Schema.unionOf(componentSchema, Schema.of(Schema.Type.NULL)));
        }
        if (!(type instanceof Class) && !(type instanceof ParameterizedType)) {
            throw new UnsupportedTypeException("Type " + type + " is not supported. Only Class or ParameterizedType are supported.");
        }
        if (Collection.class.isAssignableFrom(rawType)) {
            if (!(type instanceof ParameterizedType)) {
                throw new UnsupportedTypeException("Only supports parameterized Collection type.");
            }
            TypeToken componentType = typeToken.resolveType(((ParameterizedType)type).getActualTypeArguments()[0]);
            Schema componentSchema = this.doGenerate(componentType, knownRecords, acceptRecursion);
            return Schema.arrayOf(Schema.unionOf(componentSchema, Schema.of(Schema.Type.NULL)));
        }
        if (Map.class.isAssignableFrom(rawType)) {
            if (!(type instanceof ParameterizedType)) {
                throw new UnsupportedTypeException("Only supports parameterized Map type.");
            }
            Type[] typeArgs = ((ParameterizedType)type).getActualTypeArguments();
            TypeToken keyType = typeToken.resolveType(typeArgs[0]);
            TypeToken valueType = typeToken.resolveType(typeArgs[1]);
            Schema valueSchema = this.doGenerate(valueType, knownRecords, acceptRecursion);
            return Schema.mapOf(this.doGenerate(keyType, knownRecords, acceptRecursion), Schema.unionOf(valueSchema, Schema.of(Schema.Type.NULL)));
        }
        String recordName = typeToken.getRawType().getName();
        if (knownRecords.contains(recordName)) {
            if (acceptRecursion) {
                return Schema.recordOf(recordName);
            }
            throw new UnsupportedTypeException("Recursive type not supported for class " + recordName);
        }
        return this.generateRecord(typeToken, knownRecords, acceptRecursion);
    }

    protected abstract Schema generateRecord(TypeToken<?> var1, Set<String> var2, boolean var3) throws UnsupportedTypeException;
}

