/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.internal.asm;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.ParameterizedType;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

public final class Signatures {
    public static String getClassSignature(TypeToken<?> interfaceType) {
        SignatureWriter signWriter = new SignatureWriter();
        SignatureVisitor sv = signWriter.visitSuperclass();
        sv.visitClassType(Type.getInternalName(Object.class));
        sv.visitEnd();
        SignatureVisitor interfaceVisitor = sv.visitInterface();
        interfaceVisitor.visitClassType(Type.getInternalName((Class)interfaceType.getRawType()));
        if (interfaceType.getType() instanceof ParameterizedType) {
            for (java.lang.reflect.Type paramType : ((ParameterizedType)interfaceType.getType()).getActualTypeArguments()) {
                interfaceVisitor.visitTypeArgument('=');
                Signatures.visitTypeSignature(interfaceType.resolveType(paramType), interfaceVisitor);
            }
        }
        sv.visitEnd();
        return signWriter.toString();
    }

    public static String getMethodSignature(Method method, TypeToken<?> ... types) {
        SignatureWriter signWriter = new SignatureWriter();
        Type[] argumentTypes = method.getArgumentTypes();
        for (int i = 0; i < argumentTypes.length; ++i) {
            SignatureVisitor sv = signWriter.visitParameterType();
            if (types[i] != null) {
                Signatures.visitTypeSignature(types[i], sv);
                continue;
            }
            sv.visitClassType(argumentTypes[i].getInternalName());
            sv.visitEnd();
        }
        signWriter.visitReturnType().visitBaseType('V');
        return signWriter.toString();
    }

    public static String getFieldSignature(TypeToken<?> fieldType) {
        SignatureWriter signWriter = new SignatureWriter();
        signWriter.visitClassType(Type.getInternalName((Class)fieldType.getRawType()));
        if (fieldType.getType() instanceof ParameterizedType) {
            for (java.lang.reflect.Type paramType : ((ParameterizedType)fieldType.getType()).getActualTypeArguments()) {
                signWriter.visitTypeArgument('=');
                Signatures.visitTypeSignature(fieldType.resolveType(paramType), (SignatureVisitor)signWriter);
            }
        }
        signWriter.visitEnd();
        return signWriter.toString();
    }

    public static void visitTypeSignature(TypeToken<?> type, SignatureVisitor visitor) {
        Class rawType = type.getRawType();
        if (rawType.isPrimitive()) {
            visitor.visitBaseType(Type.getType((Class)rawType).toString().charAt(0));
            return;
        }
        if (rawType.isArray()) {
            Signatures.visitTypeSignature(type.getComponentType(), visitor.visitArrayType());
            return;
        }
        visitor.visitClassType(Type.getInternalName((Class)rawType));
        java.lang.reflect.Type visitType = type.getType();
        if (visitType instanceof ParameterizedType) {
            for (java.lang.reflect.Type argType : ((ParameterizedType)visitType).getActualTypeArguments()) {
                Signatures.visitTypeSignature(TypeToken.of((java.lang.reflect.Type)argType), visitor.visitTypeArgument('='));
            }
        }
        visitor.visitEnd();
    }

    private Signatures() {
    }
}

