/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.internal.io;

import com.google.common.base.Objects;
import io.cdap.common.internal.io.UnsupportedTypeException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class TypeRepresentation
implements ParameterizedType {
    private final boolean isClass;
    private final String rawType;
    private final TypeRepresentation enclosingType;
    private final TypeRepresentation[] parameters;
    private transient ClassLoader classLoader = null;

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
        if (this.enclosingType != null) {
            this.enclosingType.setClassLoader(loader);
        }
        if (this.parameters != null) {
            for (TypeRepresentation param : this.parameters) {
                param.setClassLoader(loader);
            }
        }
    }

    public TypeRepresentation(Type type) throws UnsupportedTypeException {
        if (type instanceof Class) {
            this.rawType = ((Class)type).getCanonicalName();
            this.enclosingType = null;
            this.parameters = null;
            this.isClass = true;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type raw = pType.getRawType();
            if (!(raw instanceof Class)) {
                throw new UnsupportedTypeException("can't represent type " + type + " (enclosing type is not a class)");
            }
            this.rawType = ((Class)raw).getName();
            Type owner = pType.getOwnerType();
            this.enclosingType = owner == null ? null : new TypeRepresentation(owner);
            Type[] typeArgs = pType.getActualTypeArguments();
            this.parameters = new TypeRepresentation[typeArgs.length];
            for (int i = 0; i < typeArgs.length; ++i) {
                this.parameters[i] = new TypeRepresentation(typeArgs[i]);
            }
            this.isClass = false;
        } else {
            throw new UnsupportedTypeException("can't represent type " + type + " (must be a class or a parametrized type)");
        }
    }

    public Type toType() {
        if (this.isClass) {
            return this.getRawType();
        }
        return this;
    }

    @Override
    public Type[] getActualTypeArguments() {
        if (this.parameters == null) {
            return null;
        }
        Type[] typeArgs = new Type[this.parameters.length];
        for (int i = 0; i < typeArgs.length; ++i) {
            typeArgs[i] = this.parameters[i].toType();
        }
        return typeArgs;
    }

    @Override
    public Type getRawType() {
        try {
            ClassLoader cl = (ClassLoader)Objects.firstNonNull((Object)this.classLoader, (Object)Objects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)this.getClass().getClassLoader()));
            return cl.loadClass(this.rawType);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot convert " + this.rawType + " to a type. ", e);
        }
    }

    @Override
    public Type getOwnerType() {
        return this.enclosingType == null ? null : this.enclosingType.toType();
    }
}

