/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.internal.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.reflect.TypeToken;
import io.cdap.common.internal.io.FieldAccessor;
import io.cdap.common.internal.io.FieldAccessorFactory;
import io.cdap.common.internal.io.FieldEntry;
import java.lang.reflect.Field;

public final class ReflectionFieldAccessorFactory
implements FieldAccessorFactory {
    private final LoadingCache<FieldEntry, FieldAccessor> fieldAccessorCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<FieldEntry, FieldAccessor>(){

        public FieldAccessor load(FieldEntry fieldEntry) throws Exception {
            Field field = null;
            for (TypeToken type : fieldEntry.getType().getTypes().classes()) {
                try {
                    field = type.getRawType().getDeclaredField(fieldEntry.getFieldName());
                    break;
                }
                catch (NoSuchFieldException e) {
                }
            }
            Preconditions.checkNotNull((Object)field, (String)"No such field in type. Type: %s, field: %s", (Object[])new Object[]{fieldEntry.getType(), fieldEntry.getFieldName()});
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            final Field finalField = field;
            final TypeToken fieldType = fieldEntry.getType().resolveType(finalField.getGenericType());
            return new FieldAccessor(){

                @Override
                public <T> void set(Object object, T value) {
                    try {
                        finalField.set(object, value);
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }

                @Override
                public <T> T get(Object object) {
                    try {
                        return (T)finalField.get(object);
                    }
                    catch (Exception e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                }

                @Override
                public boolean getBoolean(Object object) {
                    return (Boolean)this.get(object);
                }

                @Override
                public byte getByte(Object object) {
                    return (Byte)this.get(object);
                }

                @Override
                public char getChar(Object object) {
                    return ((Character)this.get(object)).charValue();
                }

                @Override
                public short getShort(Object object) {
                    return (Short)this.get(object);
                }

                @Override
                public int getInt(Object object) {
                    return (Integer)this.get(object);
                }

                @Override
                public long getLong(Object object) {
                    return (Long)this.get(object);
                }

                @Override
                public float getFloat(Object object) {
                    return ((Float)this.get(object)).floatValue();
                }

                @Override
                public double getDouble(Object object) {
                    return (Double)this.get(object);
                }

                @Override
                public void setBoolean(Object object, boolean value) {
                    this.set(object, value);
                }

                @Override
                public void setByte(Object object, byte value) {
                    this.set(object, value);
                }

                @Override
                public void setChar(Object object, char value) {
                    this.set(object, Character.valueOf(value));
                }

                @Override
                public void setShort(Object object, short value) {
                    this.set(object, value);
                }

                @Override
                public void setInt(Object object, int value) {
                    this.set(object, value);
                }

                @Override
                public void setLong(Object object, long value) {
                    this.set(object, value);
                }

                @Override
                public void setFloat(Object object, float value) {
                    this.set(object, Float.valueOf(value));
                }

                @Override
                public void setDouble(Object object, double value) {
                    this.set(object, value);
                }

                @Override
                public TypeToken<?> getType() {
                    return fieldType;
                }
            };
        }
    });

    @Override
    public FieldAccessor getFieldAccessor(TypeToken<?> type, String fieldName) {
        return (FieldAccessor)this.fieldAccessorCache.getUnchecked((Object)new FieldEntry(type, fieldName));
    }
}

