/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.http;

import com.google.common.base.Charsets;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import io.cdap.common.http.HttpResponse;
import java.lang.reflect.Type;

public final class ObjectResponse<T>
extends HttpResponse {
    private static final Gson GSON = new Gson();
    private final T object;

    public static <T> ObjectResponse<T> fromJsonBody(HttpResponse response, Type typeOfObject, Gson gson) {
        Object object = response.getResponseBody() == null ? null : gson.fromJson(new String(response.getResponseBody(), Charsets.UTF_8), typeOfObject);
        return new ObjectResponse<Object>(response, object);
    }

    public static <T> ObjectResponse<T> fromJsonBody(HttpResponse response, Type typeOfObject) {
        return ObjectResponse.fromJsonBody(response, typeOfObject, GSON);
    }

    public static <T> ObjectResponse<T> fromJsonBody(HttpResponse response, TypeToken<T> typeOfObject, Gson gson) {
        return ObjectResponse.fromJsonBody(response, typeOfObject.getType(), gson);
    }

    public static <T> ObjectResponse<T> fromJsonBody(HttpResponse response, TypeToken<T> typeOfObject) {
        return ObjectResponse.fromJsonBody(response, typeOfObject.getType(), GSON);
    }

    public static <T> ObjectResponse<T> fromJsonBody(HttpResponse response, Class<T> typeOfObject, Gson gson) {
        return ObjectResponse.fromJsonBody(response, typeOfObject, gson);
    }

    public static <T> ObjectResponse<T> fromJsonBody(HttpResponse response, Class<T> typeOfObject) {
        return ObjectResponse.fromJsonBody(response, typeOfObject, GSON);
    }

    private ObjectResponse(HttpResponse response, T object) {
        super(response.getResponseCode(), response.getResponseMessage(), response.getResponseBody(), response.getHeaders());
        this.object = object;
    }

    public T getResponseObject() {
        return this.object;
    }
}

