/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String[] getStrings(String str) {
        Collection<String> values = StringUtils.getStringCollection(str);
        if (values.isEmpty()) {
            return null;
        }
        return values.toArray(new String[values.size()]);
    }

    public static Collection<String> getStringCollection(String str) {
        ArrayList<String> values = new ArrayList<String>();
        if (str == null) {
            return values;
        }
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        values = new ArrayList();
        while (tokenizer.hasMoreTokens()) {
            values.add(tokenizer.nextToken());
        }
        return values;
    }

    public static Collection<String> getTrimmedStringCollection(String str) {
        return new ArrayList<String>(Arrays.asList(StringUtils.getTrimmedStrings(str)));
    }

    public static String[] getTrimmedStrings(String str) {
        if (null == str || "".equals(str.trim())) {
            return EMPTY_STRING_ARRAY;
        }
        return str.trim().split("\\s*,\\s*");
    }

    public static String arrayToString(String[] strs) {
        if (strs.length == 0) {
            return "";
        }
        StringBuilder sbuf = new StringBuilder();
        sbuf.append(strs[0]);
        for (int idx = 1; idx < strs.length; ++idx) {
            sbuf.append(",");
            sbuf.append(strs[idx]);
        }
        return sbuf.toString();
    }

    public static enum TraditionalBinaryPrefix {
        KILO(1024L),
        MEGA(TraditionalBinaryPrefix.KILO.value << 10),
        GIGA(TraditionalBinaryPrefix.MEGA.value << 10),
        TERA(TraditionalBinaryPrefix.GIGA.value << 10),
        PETA(TraditionalBinaryPrefix.TERA.value << 10),
        EXA(TraditionalBinaryPrefix.PETA.value << 10);

        public final long value;
        public final char symbol;

        private TraditionalBinaryPrefix(long value) {
            this.value = value;
            this.symbol = this.toString().charAt(0);
        }

        public static TraditionalBinaryPrefix valueOf(char symbol) {
            symbol = Character.toUpperCase(symbol);
            for (TraditionalBinaryPrefix prefix : TraditionalBinaryPrefix.values()) {
                if (symbol != prefix.symbol) continue;
                return prefix;
            }
            throw new IllegalArgumentException("Unknown symbol '" + symbol + "'");
        }

        public static long string2long(String s) {
            long prefix;
            int lastpos;
            char lastchar = (s = s.trim()).charAt(lastpos = s.length() - 1);
            if (Character.isDigit(lastchar)) {
                return Long.parseLong(s);
            }
            try {
                prefix = TraditionalBinaryPrefix.valueOf((char)lastchar).value;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid size prefix '" + lastchar + "' in '" + s + "'. Allowed prefixes are k, m, g, t, p, e(case insensitive)");
            }
            long num = Long.parseLong(s.substring(0, lastpos));
            if (num > Long.MAX_VALUE / prefix || num < Long.MIN_VALUE / prefix) {
                throw new IllegalArgumentException(s + " does not fit in a Long");
            }
            return num * prefix;
        }
    }
}

