/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URLEncoder;
import java.net.UnknownHostException;

public final class Networks {
    public static InetAddress resolve(String hostname, InetAddress onErrorAddress) {
        try {
            if (hostname != null) {
                return InetAddress.getByName(hostname);
            }
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return onErrorAddress;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getRandomPort() {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            return -1;
        }
    }

    private Networks() {
    }

    public static String normalizeWebappDiscoveryName(String name) throws UnsupportedEncodingException {
        if (name.endsWith("/")) {
            name = name.replaceAll("/+$", "");
        }
        if (name.contains(":80/")) {
            name = name.replace(":80/", "/");
        } else if (name.endsWith(":80")) {
            name = name.substring(0, name.length() - 3);
        }
        name = name.replace('.', '_');
        name = name.replace('-', '_');
        name = name.replace(':', '_');
        name = name.replace('/', '_');
        return URLEncoder.encode(name, Charsets.UTF_8.name());
    }
}

