/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.cli.command;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import io.cdap.common.cli.Arguments;
import io.cdap.common.cli.Command;
import io.cdap.common.cli.CommandSet;
import io.cdap.common.cli.util.DefaultHelpFormatter;
import io.cdap.common.cli.util.HelpFormatter;
import java.io.PrintStream;
import java.util.List;

public class HelpCommand
implements Command {
    private static final String COMMAND_KEY = "command";
    private final Supplier<CommandSet<Command>> getCommands;
    private final String helpHeader;
    private final HelpFormatter helpFormatter;

    public HelpCommand(CommandSet<Command> commands) {
        this(commands, null, null);
    }

    public HelpCommand(CommandSet<Command> commands, String helpHeader) {
        this(commands, helpHeader, null);
    }

    public HelpCommand(CommandSet<Command> commands, String helpHeader, HelpFormatter helpFormatter) {
        final CommandSet commandsWithHelp = new CommandSet(ImmutableList.of((Object)this), ImmutableList.of(commands));
        this.getCommands = new Supplier<CommandSet<Command>>(){

            public CommandSet<Command> get() {
                return commandsWithHelp;
            }
        };
        this.helpHeader = helpHeader;
        this.helpFormatter = helpFormatter == null ? new DefaultHelpFormatter() : helpFormatter;
    }

    @Override
    public void execute(Arguments arguments, PrintStream printStream) throws Exception {
        if (arguments.hasArgument(COMMAND_KEY)) {
            String input = arguments.get(COMMAND_KEY);
            List<Command> commands = ((CommandSet)this.getCommands.get()).findMatchCommands(input);
            if (commands.isEmpty()) {
                printStream.println(String.format("No appropriate commands for pattern: %s", input));
            } else {
                this.helpFormatter.print(commands, printStream);
            }
        } else {
            if (this.helpHeader != null) {
                printStream.println(this.helpHeader);
                printStream.println();
            }
            this.helpFormatter.print((Iterable)this.getCommands.get(), printStream);
        }
        printStream.println();
    }

    @Override
    public String getPattern() {
        return String.format("help [<%s>]", COMMAND_KEY);
    }

    @Override
    public String getDescription() {
        return "Prints usage information or description of a command";
    }
}

