/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.cli;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.cdap.common.cli.Command;
import io.cdap.common.cli.CommandMatch;
import io.cdap.common.cli.exception.InvalidCommandException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CommandSet<T extends Command>
implements Iterable<T> {
    private final List<T> commands;
    private final List<CommandSet<T>> commandSets;

    public CommandSet(Iterable<T> commands, Iterable<CommandSet<T>> commandSets) {
        this.commands = ImmutableList.copyOf(commands);
        this.commandSets = ImmutableList.copyOf(commandSets);
    }

    public CommandSet(Iterable<T> commands) {
        this(commands, (Iterable<CommandSet<T>>)ImmutableList.of());
    }

    @Override
    public Iterator<T> iterator() {
        return Iterables.concat(this.commands, (Iterable)Iterables.concat(this.commandSets)).iterator();
    }

    public CommandMatch findMatch(String input) throws InvalidCommandException {
        String trimmedInput = input.trim();
        for (Command command : this) {
            String pattern = this.getMatchPattern(command.getPattern());
            if (!trimmedInput.matches(pattern)) continue;
            return new CommandMatch(command, trimmedInput);
        }
        throw new InvalidCommandException(input);
    }

    public List<T> findMatchCommands(String input) {
        ArrayList appropriateCommands = Lists.newArrayList();
        for (Command command : this) {
            if (!command.getPattern().startsWith(input)) continue;
            appropriateCommands.add(command);
        }
        return appropriateCommands;
    }

    public Iterable<T> getCommands() {
        return this.commands;
    }

    public Iterable<CommandSet<T>> getCommandSets() {
        return this.commandSets;
    }

    private String getMatchPattern(String pattern) {
        String mandatoryPart = pattern.trim().replaceAll("(\\s+?)\\[.+?\\]", "($1.+?(\\\\s|\\$))*");
        mandatoryPart = mandatoryPart.replaceAll("\\s+", "\\\\s+");
        return mandatoryPart.replaceAll("<.+?>", ".+?");
    }
}

