/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.cli;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

public class Arguments {
    private final Map<String, String> arguments;
    private final String rawInput;

    public Arguments(Map<String, String> arguments, String rawInput) {
        this.rawInput = rawInput;
        this.arguments = ImmutableMap.copyOf(arguments);
    }

    public int size() {
        return this.arguments.size();
    }

    public String getRawInput() {
        return this.rawInput;
    }

    public boolean hasArgument(String key) {
        return this.arguments.containsKey(key);
    }

    public String get(String key) {
        this.checkRequiredArgument(key);
        return this.arguments.get(key);
    }

    @Deprecated
    @Nullable
    public String get(String key, String defaultValue) {
        return this.getOptional(key, defaultValue);
    }

    @Nullable
    public String getOptional(String key, String defaultValue) {
        String value = this.arguments.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    @Nullable
    public String getOptional(String key) {
        return this.getOptional(key, null);
    }

    public int getInt(String key) {
        this.checkRequiredArgument(key);
        return Integer.parseInt(this.arguments.get(key));
    }

    public Integer getInt(String key, int defaultValue) {
        return this.getIntOptional(key, defaultValue);
    }

    @Nullable
    public Integer getIntOptional(String key, Integer defaultValue) {
        String value = this.arguments.get(key);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    @Nullable
    public Integer getIntOptional(String key) {
        return this.getIntOptional(key, null);
    }

    public Long getLong(String key) {
        this.checkRequiredArgument(key);
        return Long.parseLong(this.arguments.get(key));
    }

    public Long getLong(String key, long defaultValue) {
        return this.getLongOptional(key, defaultValue);
    }

    @Nullable
    public Long getLongOptional(String key, @Nullable Long defaultValue) {
        String value = this.arguments.get(key);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    @Nullable
    public Long getLongOptional(String key) {
        return this.getLongOptional(key, null);
    }

    private void checkRequiredArgument(String key) {
        if (!this.arguments.containsKey(key)) {
            throw new NoSuchElementException("Missing required argument: " + key);
        }
    }
}

