/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.common.cli.util;

import java.util.ArrayList;
import java.util.List;

public class Parser {
    public static final char MANDATORY_ARG_BEGINNING = '<';
    public static final char MANDATORY_ARG_ENDING = '>';
    public static final char OPTIONAL_PART_BEGINNING = '[';
    public static final char OPTIONAL_PART_ENDING = ']';
    private static final char SEPARATOR = ' ';
    private static final char ARG_WRAPPER = '\"';
    private static final char JSON_WRAPPER = '\'';

    public static List<String> parseInput(String input) {
        ArrayList<String> splitInput = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        State state = State.EMPTY;
        char[] chars = input.toCharArray();
        block5: for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            switch (state) {
                case EMPTY: {
                    if (ch == ' ') {
                        if (builder.length() > 0) {
                            splitInput.add(builder.toString());
                        }
                        builder.setLength(0);
                        while (i + 1 < chars.length && chars[i + 1] == ' ') {
                            ++i;
                        }
                        continue block5;
                    }
                    if (ch == '\"') {
                        state = State.IN_DOUBLE_QUOTES;
                    }
                    if (ch == '\'') {
                        state = State.IN_QUOTES;
                    }
                    builder.append(ch);
                    continue block5;
                }
                case IN_DOUBLE_QUOTES: {
                    if (ch == '\"') {
                        state = State.EMPTY;
                    }
                    builder.append(ch);
                    continue block5;
                }
                case IN_QUOTES: {
                    if (ch == '\'') {
                        state = State.EMPTY;
                    }
                    builder.append(ch);
                }
            }
        }
        if (builder.length() > 0) {
            splitInput.add(builder.toString());
        }
        return splitInput;
    }

    public static List<String> parsePattern(String pattern) {
        ArrayList<String> splitPattern = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        State state = State.EMPTY;
        block5: for (char ch : pattern.toCharArray()) {
            switch (state) {
                case EMPTY: {
                    if (ch == ' ') {
                        splitPattern.add(builder.toString());
                        builder.setLength(0);
                        continue block5;
                    }
                    if (ch == '<') {
                        state = State.IN_MANDATORY_ARG;
                    }
                    if (ch == '[') {
                        state = State.IN_OPTIONAL_PART;
                    }
                    builder.append(ch);
                    continue block5;
                }
                case IN_MANDATORY_ARG: {
                    if (ch == '>') {
                        state = State.EMPTY;
                    }
                    builder.append(ch);
                    continue block5;
                }
                case IN_OPTIONAL_PART: {
                    if (ch == ']') {
                        state = State.EMPTY;
                    }
                    builder.append(ch);
                }
            }
        }
        if (builder.length() > 0) {
            splitPattern.add(builder.toString());
        }
        return splitPattern;
    }

    private static enum State {
        EMPTY,
        IN_QUOTES,
        IN_DOUBLE_QUOTES,
        IN_MANDATORY_ARG,
        IN_OPTIONAL_PART;

    }
}

