/*
 * Decompiled with CFR 0.152.
 */
package io.cana.steam.common.config;

import io.cana.steam.common.config.ConfigLoader;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class PropConfigLoader
extends ConfigLoader {
    public static void loadConfig(String path) throws IOException {
        if (null == path) {
            return;
        }
        PropConfigLoader.loadConfig(PropConfigLoader.readConfig(path));
    }

    public static Properties readConfig(String path) throws IOException {
        Properties properties = new Properties();
        if (null == path) {
            return properties;
        }
        int index = path.indexOf("classpath");
        if (index == 0) {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(path.substring(12));
            while (resources.hasMoreElements()) {
                properties.load(resources.nextElement().openStream());
            }
        } else {
            properties.load(new FileReader(path));
        }
        return properties;
    }

    public static void loadConfig(Map<?, ?> props) {
        if (null == props) {
            return;
        }
        HashSet keySet = new HashSet(CONFIG.keySet());
        for (Map.Entry<?, ?> entry : props.entrySet()) {
            String key;
            if (!Objects.nonNull(entry.getKey()) || !Objects.nonNull(entry.getValue()) || keySet.contains(key = String.valueOf(entry.getKey()).trim())) continue;
            keySet.add(key);
            String value = String.valueOf(entry.getValue()).trim();
            CONFIG.put(key, value);
        }
    }
}

