/*
 * Decompiled with CFR 0.152.
 */
package io.cana.steam.common.config;

import io.cana.steam.common.config.exception.ConfigParseException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ConfigLoader {
    protected static final Map<String, Object> CONFIG = new ConcurrentHashMap<String, Object>(64);

    public static Map<String, Object> allConfig() {
        return CONFIG;
    }

    public static void addConfig(String key, Object value) {
        CONFIG.put(key, value);
    }

    public static void addConfig(Map<String, Object> config) {
        CONFIG.putAll(config);
    }

    public static boolean loadBool(String key) {
        return ConfigLoader.loadConfig(key, false, null, Boolean.class, Boolean::valueOf);
    }

    public static boolean loadBool(String pre, String key) {
        return ConfigLoader.loadConfig(pre + key, false, null, Boolean.class, Boolean::valueOf);
    }

    public static boolean loadBoolOrDefault(String key, boolean def) {
        return ConfigLoader.loadConfig(key, true, def, Boolean.class, Boolean::valueOf);
    }

    public static boolean loadBoolOrDefault(String pre, String key, boolean def) {
        return ConfigLoader.loadConfig(pre + key, true, def, Boolean.class, Boolean::valueOf);
    }

    public static int loadInt(String key) {
        return ConfigLoader.loadConfig(key, false, null, Integer.class, Integer::valueOf);
    }

    public static int loadInt(String pre, String key) {
        return ConfigLoader.loadConfig(pre + key, false, null, Integer.class, Integer::valueOf);
    }

    public static int loadIntOrDefault(String key, int def) {
        return ConfigLoader.loadConfig(key, true, def, Integer.class, Integer::valueOf);
    }

    public static int loadIntOrDefault(String pre, String key, int def) {
        return ConfigLoader.loadConfig(pre + key, true, def, Integer.class, Integer::valueOf);
    }

    public static int loadIntWithSystem(String key, String def) {
        return Integer.parseInt(ConfigLoader.loadConfig(key, def, true, false));
    }

    public static int loadIntWithSystem(String pre, String key, String def) {
        String nowKey = pre + key;
        return Integer.parseInt(ConfigLoader.loadConfig(nowKey, def, true, false));
    }

    public static int loadIntWithEnv(String key, String def) {
        return Integer.parseInt(ConfigLoader.loadConfig(key, def, true, true));
    }

    public static int loadIntWithEnv(String pre, String key, String def) {
        String nowKey = pre + key;
        return Integer.parseInt(ConfigLoader.loadConfig(nowKey, def, true, true));
    }

    public static long loadLong(String key) {
        return ConfigLoader.loadConfig(key, false, null, Long.class, Long::valueOf);
    }

    public static long loadLong(String pre, String key) {
        return ConfigLoader.loadConfig(pre + key, false, null, Long.class, Long::valueOf);
    }

    public static long loadLongOrDefault(String key, long def) {
        return ConfigLoader.loadConfig(key, true, def, Long.class, Long::valueOf);
    }

    public static long loadLongOrDefault(String pre, String key, long def) {
        return ConfigLoader.loadConfig(pre + key, true, def, Long.class, Long::valueOf);
    }

    public static long loadLongWithSystem(String key, String def) {
        return Long.parseLong(ConfigLoader.loadConfig(key, def, true, false));
    }

    public static long loadLongWithSystem(String pre, String key, String def) {
        String nowKey = pre + key;
        return Long.parseLong(ConfigLoader.loadConfig(nowKey, def, true, false));
    }

    public static long loadLongWithEnv(String key, String def) {
        return Long.parseLong(ConfigLoader.loadConfig(key, def, true, true));
    }

    public static long loadLongWithEnv(String pre, String key, String def) {
        String nowKey = pre + key;
        return Long.parseLong(ConfigLoader.loadConfig(nowKey, def, true, true));
    }

    public static int loadTimeOrDefault(String key, String def) {
        return ConfigLoader.parseTime(ConfigLoader.loadConfig(key, true, def, String.class, null));
    }

    public static int loadTimeOrDefault(String pre, String key, String def) {
        return ConfigLoader.parseTime(ConfigLoader.loadConfig(pre + key, true, def, String.class, null));
    }

    private static int parseTime(String time) {
        if (null == time) {
            throw new ConfigParseException("Config not exist with null");
        }
        int length = (time = time.trim()).length();
        if (length < 2) {
            throw new ConfigParseException("Config is incorrect with " + time);
        }
        char last = time.charAt(length - 1);
        if (last == 'd') {
            return ConfigLoader.parseTime(time, length, 1) * 24 * 60 * 60 * 1000;
        }
        if (last == 'h') {
            return ConfigLoader.parseTime(time, length, 1) * 60 * 60 * 1000;
        }
        if (last == 'm') {
            return ConfigLoader.parseTime(time, length, 1) * 60 * 1000;
        }
        if (last == 's') {
            if (time.charAt(length - 2) == 'm') {
                return ConfigLoader.parseTime(time, length, 2);
            }
            return ConfigLoader.parseTime(time, length, 1) * 1000;
        }
        throw new ConfigParseException("Config time parse error with " + time);
    }

    private static int parseTime(String time, int size, int sub) {
        try {
            return Integer.parseInt(time.substring(0, size - sub));
        }
        catch (Exception e) {
            throw new ConfigParseException("Config time format is wrong with " + time);
        }
    }

    public static String loadString(String pre, String key) {
        return ConfigLoader.loadConfig(pre + key, false, null, String.class, null);
    }

    public static String loadString(String key) {
        return ConfigLoader.loadConfig(key, false, null, String.class, null);
    }

    public static String loadStringOrDefault(String pre, String key, String def) {
        return ConfigLoader.loadConfig(pre + key, true, def, String.class, null);
    }

    public static String loadStringOrDefault(String key, String def) {
        return ConfigLoader.loadConfig(key, true, def, String.class, null);
    }

    public static String loadStringWithSystem(String key, String def) {
        return ConfigLoader.loadConfig(key, def, true, false);
    }

    public static String loadStringWithSystem(String pre, String key, String def) {
        String nowKey = pre + key;
        return ConfigLoader.loadConfig(nowKey, def, true, false);
    }

    public static String loadStringWithEnv(String key, String def) {
        return ConfigLoader.loadConfig(key, def, true, true);
    }

    public static String loadStringWithEnv(String pre, String key, String def) {
        String nowKey = pre + key;
        return ConfigLoader.loadConfig(nowKey, def, true, true);
    }

    private static String loadConfig(String key, String value, boolean sys, boolean env) {
        String getValue;
        if (env && null != (getValue = System.getenv(key))) {
            return getValue;
        }
        if (sys && null != (getValue = System.getProperty(key))) {
            return getValue;
        }
        return ConfigLoader.loadConfig(key, true, value, String.class, null);
    }

    private static <T> T loadConfig(String key, boolean def, T value, Class<T> clazz, Function<String, T> function) {
        Object obj = CONFIG.get(key);
        if (null == obj) {
            if (def) {
                return value;
            }
            throw new ConfigParseException("Config not exist with key " + key);
        }
        return ConfigLoader.convertType(obj, clazz, function);
    }

    private static <T> T convertType(Object obj, Class<T> clazz, Function<String, T> function) {
        if (String.class == clazz) {
            return (T)String.valueOf(obj).trim();
        }
        if (obj.getClass() == clazz) {
            return clazz.cast(obj);
        }
        return function.apply(String.valueOf(obj));
    }
}

