/*
 * Decompiled with CFR 0.152.
 */
package io.cana.cella.common.serialize;

import io.cana.steam.common.digest.Base64;
import io.cana.steam.common.utils.StringUtil;
import io.protostuff.LinkedBuffer;
import io.protostuff.MessageCollectionSchema;
import io.protostuff.MessageMapSchema;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class Protostuff {
    public static LinkedBuffer getBuffer() {
        return (LinkedBuffer)Inner.BUFFER.get();
    }

    public static byte[] collection2Byte(Collection<String> list) {
        return Protostuff.collection2Byte(list, String.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E> byte[] collection2Byte(Collection<E> list, Class<E> ele) {
        MessageCollectionSchema schema = new MessageCollectionSchema(Inner.getSchema(ele));
        try {
            byte[] byArray = ProtostuffIOUtil.toByteArray(list, (Schema)schema, (LinkedBuffer)Protostuff.getBuffer());
            return byArray;
        }
        finally {
            Protostuff.getBuffer().clear();
        }
    }

    public static String collection2String(Collection<String> list) {
        return Base64.encode((byte[])Protostuff.collection2Byte(list));
    }

    public static <E> String collection2String(Collection<E> list, Class<E> ele) {
        return Base64.encode((byte[])Protostuff.collection2Byte(list, ele));
    }

    public static <V> byte[] map2Byte(Map<String, V> map, Class<V> value) {
        return Protostuff.map2Byte(map, String.class, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> byte[] map2Byte(Map<K, V> map, Class<K> key, Class<V> value) {
        MessageMapSchema schema = new MessageMapSchema(Inner.getSchema(key), Inner.getSchema(value));
        try {
            byte[] byArray = ProtostuffIOUtil.toByteArray(map, (Schema)schema, (LinkedBuffer)Protostuff.getBuffer());
            return byArray;
        }
        finally {
            Protostuff.getBuffer().clear();
        }
    }

    public static <V> String map2String(Map<String, V> map, Class<V> value) {
        return Base64.encode((byte[])Protostuff.map2Byte(map, String.class, value));
    }

    public static <K, V> String map2String(Map<K, V> map, Class<K> key, Class<V> value) {
        return Base64.encode((byte[])Protostuff.map2Byte(map, key, value));
    }

    public static <T> byte[] toByte(T obj) {
        try {
            Class<?> clazz = obj.getClass();
            byte[] byArray = ProtostuffIOUtil.toByteArray(obj, (Schema)Inner.getSchema(clazz), (LinkedBuffer)Protostuff.getBuffer());
            return byArray;
        }
        finally {
            Protostuff.getBuffer().clear();
        }
    }

    public static Collection<String> byte2Collection(byte[] data) {
        return Protostuff.byte2Collection(data, String.class);
    }

    public static <E> Collection<E> byte2Collection(byte[] data, Class<E> ele) {
        MessageCollectionSchema schema = new MessageCollectionSchema(Inner.getSchema(ele));
        Collection list = schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])data, (Object)list, (Schema)schema);
        return list;
    }

    public static Collection<String> string2Collection(String data) {
        return Protostuff.byte2Collection(Base64.decode((String)data), String.class);
    }

    public static <E> Collection<E> string2Collection(String data, Class<E> ele) {
        return Protostuff.byte2Collection(Base64.decode((String)data), ele);
    }

    public static Map<String, String> byte2Map(byte[] data) {
        return Protostuff.byte2Map(data, String.class, String.class);
    }

    public static <V> Map<String, V> byte2Map(byte[] data, Class<V> value) {
        return Protostuff.byte2Map(data, String.class, value);
    }

    public static <K, V> Map<K, V> byte2Map(byte[] data, Class<K> key, Class<V> value) {
        MessageMapSchema schema = new MessageMapSchema(Inner.getSchema(key), Inner.getSchema(value));
        Map map = schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])data, (Object)map, (Schema)schema);
        return map;
    }

    public static <V> Map<String, V> string2Map(String data, Class<V> value) {
        return Protostuff.byte2Map(Base64.decode((String)data), String.class, value);
    }

    public static <K, V> Map<K, V> string2Map(String data, Class<K> key, Class<V> value) {
        return Protostuff.byte2Map(Base64.decode((String)data), key, value);
    }

    public static <T> T fromString(String str, Class<T> clazz) {
        if (StringUtil.isBlank((String)str).booleanValue()) {
            return null;
        }
        Schema schema = Inner.getSchema(clazz);
        Object obj = schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])Base64.decode((String)str), (Object)obj, (Schema)schema);
        return (T)obj;
    }

    public static <T> T fromByte(byte[] data, Class<T> clazz) {
        if (null == data || data.length == 0) {
            return null;
        }
        Schema schema = Inner.getSchema(clazz);
        Object obj = schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])data, (Object)obj, (Schema)schema);
        return (T)obj;
    }

    public static <T> T fromByte(byte[] data, int offset, int length, Class<T> clazz) {
        if (null == data || data.length == 0) {
            return null;
        }
        Schema schema = Inner.getSchema(clazz);
        Object obj = schema.newMessage();
        ProtostuffIOUtil.mergeFrom((byte[])data, (int)offset, (int)length, (Object)obj, (Schema)schema);
        return (T)obj;
    }

    public static class Inner {
        private static final ThreadLocal<LinkedBuffer> BUFFER = ThreadLocal.withInitial(() -> LinkedBuffer.allocate((int)0x100000));
        private static final Map<Class<?>, Schema<?>> SCHEMA_CACHE = new ConcurrentHashMap();

        private static <T> Schema<T> getSchema(Class<T> clazz) {
            Schema schema = SCHEMA_CACHE.get(clazz);
            if (Objects.isNull(schema) && Objects.nonNull(schema = RuntimeSchema.getSchema(clazz))) {
                SCHEMA_CACHE.put(clazz, schema);
            }
            return schema;
        }
    }
}

