package io.cana.steam.common.serialize;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;

/**
 * @author Dasheng
 * @create 2017-06-07 16:09
 */
public class JacksonMapper {
    public static class SnakeCase {
        /**
         * 将字段转为蛇形
         */
        private static final ObjectMapper MAPPER = Jackson.getMapper().copy();

        static {
            try {
                Class.forName("com.fasterxml.jackson.databind.PropertyNamingStrategies");
                MAPPER.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
            } catch (Exception e) {
                MAPPER.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            }
        }
    }

    public static class ExcludeEmpty {
        /**
         * 忽略对象中值为NULL或""的属性
         */
        private static final ObjectMapper MAPPER = Jackson.getMapper().copy();

        static {
            MAPPER.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        }
    }

    public static class ExcludeDefault {
        /**
         * 忽略对象中值为默认值的属性
         */
        private static final ObjectMapper MAPPER = Jackson.getMapper().copy();

        static {
            MAPPER.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        }
    }

    public static ObjectMapper getSnakeMapper() {
        return SnakeCase.MAPPER;
    }

    public static ObjectMapper getNoEmptyMapper() {
        return ExcludeEmpty.MAPPER;
    }

    public static ObjectMapper getNoDefaultMapper() {
        return ExcludeDefault.MAPPER;
    }
}
