/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.http;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.squareup.okhttp.CertificatePinner;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import io.bytom.common.Configuration;
import io.bytom.common.Utils;
import io.bytom.exception.APIException;
import io.bytom.exception.BytomException;
import io.bytom.exception.ConfigurationException;
import io.bytom.exception.JSONException;
import io.bytom.http.BatchResponse;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;

public class Client {
    private String url;
    private String accessToken;
    private OkHttpClient httpClient;
    private static final char[] DEFAULT_KEYSTORE_PASSWORD = "123456".toCharArray();
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static String version = "dev";
    public static Logger logger = Logger.getLogger(Client.class);
    private static final Random randomGenerator;
    private static final int MAX_RETRIES = 10;
    private static final int RETRY_BASE_DELAY_MILLIS = 40;
    private static final int RETRY_MAX_DELAY_MILLIS = 15000;
    private static final int[] RETRIABLE_STATUS_CODES;

    public static Client generateClient() throws BytomException {
        String coreURL = Configuration.getValue("bytom.api.url");
        String accessToken = Configuration.getValue("client.access.token");
        if (coreURL == null || coreURL.isEmpty()) {
            coreURL = "http://127.0.0.1:9888";
        }
        if (coreURL.endsWith("/")) {
            coreURL = coreURL.substring(0, coreURL.length() - 1);
            logger.info((Object)"check the coreURL is right.");
        }
        return new Client(coreURL, accessToken);
    }

    public Client(Builder builder) throws ConfigurationException {
        if (builder.url.endsWith("/")) {
            builder.url = builder.url.substring(0, builder.url.length() - 1);
        }
        this.url = builder.url;
        this.accessToken = builder.accessToken;
        this.httpClient = this.buildHttpClient(builder);
    }

    public Client() throws BytomException {
        this(new Builder());
    }

    public Client(String url) throws BytomException {
        this(new Builder().setUrl(url));
    }

    public Client(String url, String accessToken) throws BytomException {
        this(new Builder().setUrl(url).setAccessToken(accessToken));
    }

    public <T> T request(String action, Object body, final Type tClass) throws BytomException {
        ResponseCreator rc = new ResponseCreator<T>(){

            @Override
            public T create(Response response, Gson deserializer) throws IOException, BytomException {
                JsonElement root = new JsonParser().parse(response.body().charStream());
                JsonElement status = root.getAsJsonObject().get("status");
                JsonElement data = root.getAsJsonObject().get("data");
                if (status != null && status.toString().contains("fail")) {
                    throw new BytomException(root.getAsJsonObject().get("msg").toString());
                }
                if (data != null) {
                    return deserializer.fromJson(data, tClass);
                }
                return deserializer.fromJson(response.body().charStream(), tClass);
            }
        };
        return this.post(action, body, rc);
    }

    public void request(String action, Object body) throws BytomException {
        ResponseCreator<Object> rc = new ResponseCreator<Object>(){

            @Override
            public Object create(Response response, Gson deserializer) throws IOException, BytomException {
                JsonElement root = new JsonParser().parse(response.body().charStream());
                JsonElement status = root.getAsJsonObject().get("status");
                JsonElement data = root.getAsJsonObject().get("data");
                if (status != null && status.toString().contains("fail")) {
                    throw new BytomException(root.getAsJsonObject().get("msg").toString());
                }
                return null;
            }
        };
        this.post(action, body, rc);
    }

    public <T> T requestGet(String action, Object body, final String key, final Type tClass) throws BytomException {
        ResponseCreator rc = new ResponseCreator<T>(){

            @Override
            public T create(Response response, Gson deserializer) throws IOException, BytomException {
                JsonElement root = new JsonParser().parse(response.body().charStream());
                JsonElement status = root.getAsJsonObject().get("status");
                JsonElement data = root.getAsJsonObject().get("data");
                if (status != null && status.toString().contains("fail")) {
                    throw new BytomException(root.getAsJsonObject().get("msg").toString());
                }
                if (data != null) {
                    return deserializer.fromJson(data.getAsJsonObject().get(key), tClass);
                }
                return deserializer.fromJson(response.body().charStream(), tClass);
            }
        };
        return this.post(action, body, rc);
    }

    public <T> BatchResponse<T> batchRequest(String action, Object body, final Type tClass, final Type eClass) throws BytomException {
        ResponseCreator rc = new ResponseCreator<BatchResponse<T>>(){

            @Override
            public BatchResponse<T> create(Response response, Gson deserializer) throws BytomException, IOException {
                return new BatchResponse(response, deserializer, tClass, eClass);
            }
        };
        return (BatchResponse)this.post(action, body, rc);
    }

    public <T> T singletonBatchRequest(String action, Object body, final Type tClass, final Type eClass) throws BytomException {
        ResponseCreator rc = new ResponseCreator<T>(){

            @Override
            public T create(Response response, Gson deserializer) throws BytomException, IOException {
                BatchResponse batch = new BatchResponse(response, deserializer, tClass, eClass);
                List<APIException> errors = batch.errors();
                if (errors.size() == 1) {
                    throw errors.get(0);
                }
                List successes = batch.successes();
                if (successes.size() == 1) {
                    return successes.get(0);
                }
                throw new BytomException("Invalid singleton response.");
            }
        };
        return this.post(action, body, rc);
    }

    public boolean hasAccessToken() {
        return this.accessToken != null && !this.accessToken.isEmpty();
    }

    public String accessToken() {
        return this.accessToken;
    }

    public String getUrl() {
        return this.url;
    }

    public void pinCertificate(String provider, String subjPubKeyInfoHash) {
        CertificatePinner cp = new CertificatePinner.Builder().add(provider, new String[]{subjPubKeyInfoHash}).build();
        this.httpClient.setCertificatePinner(cp);
    }

    public void setConnectTimeout(long timeout, TimeUnit unit) {
        this.httpClient.setConnectTimeout(timeout, unit);
    }

    public void setReadTimeout(long timeout, TimeUnit unit) {
        this.httpClient.setReadTimeout(timeout, unit);
    }

    public void setWriteTimeout(long timeout, TimeUnit unit) {
        this.httpClient.setWriteTimeout(timeout, unit);
    }

    public void setProxy(Proxy proxy) {
        this.httpClient.setProxy(proxy);
    }

    private <T> T post(String path, Object body, ResponseCreator<T> respCreator) throws BytomException {
        RequestBody requestBody = RequestBody.create((MediaType)JSON, (String)Utils.serializer.toJson(body));
        Object exception = null;
        URL endpointURL = null;
        try {
            endpointURL = new URL(this.url + "/" + path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        Request.Builder builder = new Request.Builder().header("User-Agent", "bytom-sdk-java/" + version).url(endpointURL).method("POST", requestBody);
        if (this.hasAccessToken()) {
            builder = builder.header("Authorization", this.buildCredentials());
        }
        Request req = builder.build();
        Response resp = null;
        T object = null;
        try {
            resp = this.checkError(this.httpClient.newCall(req).execute());
            object = respCreator.create(resp, Utils.serializer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return object;
    }

    private OkHttpClient buildHttpClient(Builder builder) throws ConfigurationException {
        OkHttpClient httpClient = builder.baseHttpClient.clone();
        try {
            if (builder.trustManagers != null) {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(builder.keyManagers, builder.trustManagers, null);
                httpClient.setSslSocketFactory(sslContext.getSocketFactory());
            }
        }
        catch (GeneralSecurityException ex) {
            throw new ConfigurationException("Unable to configure TLS", ex);
        }
        if (builder.readTimeoutUnit != null) {
            httpClient.setReadTimeout(builder.readTimeout, builder.readTimeoutUnit);
        }
        if (builder.writeTimeoutUnit != null) {
            httpClient.setWriteTimeout(builder.writeTimeout, builder.writeTimeoutUnit);
        }
        if (builder.connectTimeoutUnit != null) {
            httpClient.setConnectTimeout(builder.connectTimeout, builder.connectTimeoutUnit);
        }
        if (builder.pool != null) {
            httpClient.setConnectionPool(builder.pool);
        }
        if (builder.proxy != null) {
            httpClient.setProxy(builder.proxy);
        }
        if (builder.cp != null) {
            httpClient.setCertificatePinner(builder.cp);
        }
        return httpClient;
    }

    private static int retryDelayMillis(int retryAttempt) {
        int max = 40 * (1 << retryAttempt - 1);
        max = Math.min(max, 15000);
        return randomGenerator.nextInt(max / 2) + max / 2 + 1;
    }

    private static boolean isRetriableStatusCode(int statusCode) {
        for (int i = 0; i < RETRIABLE_STATUS_CODES.length; ++i) {
            if (RETRIABLE_STATUS_CODES[i] != statusCode) continue;
            return true;
        }
        return false;
    }

    private Response checkError(Response response) throws BytomException {
        if (response.code() / 100 != 2) {
            try {
                APIException err = (APIException)Utils.serializer.fromJson(response.body().charStream(), APIException.class);
                if (err.code != null) {
                    err.statusCode = response.code();
                    throw err;
                }
            }
            catch (IOException ex) {
                throw new JSONException("Unable to read body. ");
            }
        }
        return response;
    }

    private String buildCredentials() {
        String user = "";
        String pass = "";
        if (this.hasAccessToken()) {
            String[] parts = this.accessToken.split(":");
            if (parts.length >= 1) {
                user = parts[0];
            }
            if (parts.length >= 2) {
                pass = parts[1];
            }
        }
        return Credentials.basic((String)user, (String)pass);
    }

    public int hashCode() {
        int code = this.url.hashCode();
        if (this.hasAccessToken()) {
            code = code * 31 + this.accessToken.hashCode();
        }
        return code;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Client)) {
            return false;
        }
        Client other = (Client)o;
        if (!this.url.equalsIgnoreCase(other.url)) {
            return false;
        }
        return Objects.equals(this.accessToken, other.accessToken);
    }

    static {
        InputStream in = Client.class.getClassLoader().getResourceAsStream("properties.json");
        if (in != null) {
            InputStreamReader inr = new InputStreamReader(in);
            version = ((BuildProperties)Utils.serializer.fromJson((Reader)inr, BuildProperties.class)).version;
        }
        randomGenerator = new Random();
        RETRIABLE_STATUS_CODES = new int[]{408, 429, 500, 502, 503, 504, 509};
    }

    public static class Builder {
        private String url;
        private OkHttpClient baseHttpClient;
        private String accessToken;
        private CertificatePinner cp;
        private KeyManager[] keyManagers;
        private TrustManager[] trustManagers;
        private long connectTimeout;
        private TimeUnit connectTimeoutUnit;
        private long readTimeout;
        private TimeUnit readTimeoutUnit;
        private long writeTimeout;
        private TimeUnit writeTimeoutUnit;
        private Proxy proxy;
        private ConnectionPool pool;

        public Builder() {
            this.baseHttpClient = new OkHttpClient();
            this.baseHttpClient.setFollowRedirects(false);
            this.setDefaults();
        }

        public Builder(Client client) {
            this.baseHttpClient = client.httpClient.clone();
            this.url = client.url;
            this.accessToken = client.accessToken;
        }

        private void setDefaults() {
            this.setReadTimeout(30L, TimeUnit.SECONDS);
            this.setWriteTimeout(30L, TimeUnit.SECONDS);
            this.setConnectTimeout(30L, TimeUnit.SECONDS);
            this.setConnectionPool(50, 2L, TimeUnit.MINUTES);
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Builder setX509KeyPair(InputStream certStream, InputStream keyStream) throws ConfigurationException {
            try (PEMParser parser = new PEMParser((Reader)new InputStreamReader(keyStream));){
                PrivateKeyInfo info;
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)factory.generateCertificate(certStream);
                Object obj = parser.readObject();
                if (obj instanceof PEMKeyPair) {
                    PEMKeyPair kp = (PEMKeyPair)obj;
                    info = kp.getPrivateKeyInfo();
                } else {
                    if (!(obj instanceof PrivateKeyInfo)) throw new ConfigurationException("Unsupported private key provided.");
                    info = (PrivateKeyInfo)obj;
                }
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(info.getEncoded());
                KeyFactory kf = KeyFactory.getInstance("RSA");
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, DEFAULT_KEYSTORE_PASSWORD);
                keyStore.setCertificateEntry("cert", certificate);
                keyStore.setKeyEntry("key", kf.generatePrivate(spec), DEFAULT_KEYSTORE_PASSWORD, new X509Certificate[]{certificate});
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, DEFAULT_KEYSTORE_PASSWORD);
                this.keyManagers = keyManagerFactory.getKeyManagers();
                Builder builder = this;
                return builder;
            }
            catch (IOException | GeneralSecurityException ex) {
                throw new ConfigurationException("Unable to store X.509 cert/key pair", ex);
            }
        }

        /*
         * Exception decompiling
         */
        public Builder setX509KeyPair(String certPath, String keyPath) throws ConfigurationException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public Builder setTrustedCerts(InputStream is) throws ConfigurationException {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(is);
                if (certificates.isEmpty()) {
                    throw new IllegalArgumentException("expected non-empty set of trusted certificates");
                }
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, DEFAULT_KEYSTORE_PASSWORD);
                int index = 0;
                for (Certificate certificate : certificates) {
                    String certificateAlias = Integer.toString(index++);
                    keyStore.setCertificateEntry(certificateAlias, certificate);
                }
                KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(keyStore, DEFAULT_KEYSTORE_PASSWORD);
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                Object[] trustManagers = trustManagerFactory.getTrustManagers();
                if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                    throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
                }
                this.trustManagers = trustManagers;
                return this;
            }
            catch (IOException | GeneralSecurityException ex) {
                throw new ConfigurationException("Unable to configure trusted CA certs", ex);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Builder setTrustedCerts(String path) throws ConfigurationException {
            try (FileInputStream is = new FileInputStream(path);){
                Builder builder = this.setTrustedCerts(is);
                return builder;
            }
            catch (IOException ex) {
                throw new ConfigurationException("Unable to configure trusted CA certs", ex);
            }
        }

        public Builder pinCertificate(String provider, String subjPubKeyInfoHash) {
            this.cp = new CertificatePinner.Builder().add(provider, new String[]{subjPubKeyInfoHash}).build();
            return this;
        }

        public Builder setConnectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeout = timeout;
            this.connectTimeoutUnit = unit;
            return this;
        }

        public Builder setReadTimeout(long timeout, TimeUnit unit) {
            this.readTimeout = timeout;
            this.readTimeoutUnit = unit;
            return this;
        }

        public Builder setWriteTimeout(long timeout, TimeUnit unit) {
            this.writeTimeout = timeout;
            this.writeTimeoutUnit = unit;
            return this;
        }

        public Builder setProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder setConnectionPool(int maxIdle, long timeout, TimeUnit unit) {
            this.pool = new ConnectionPool(maxIdle, unit.toMillis(timeout));
            return this;
        }

        public Client build() throws ConfigurationException {
            return new Client(this);
        }
    }

    public static interface ResponseCreator<T> {
        public T create(Response var1, Gson var2) throws BytomException, IOException;
    }

    private static class BuildProperties {
        public String version;

        private BuildProperties() {
        }
    }
}

