/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.http;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.squareup.okhttp.Response;
import io.bytom.exception.APIException;
import io.bytom.exception.BytomException;
import io.bytom.exception.JSONException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BatchResponse<T> {
    private Response response;
    private Map<Integer, T> successesByIndex = new LinkedHashMap<Integer, T>();
    private Map<Integer, APIException> errorsByIndex = new LinkedHashMap<Integer, APIException>();

    public BatchResponse(Response response, Gson serializer, Type tClass, Type eClass) throws BytomException, IOException {
        this.response = response;
        try {
            JsonArray root = new JsonParser().parse(response.body().charStream()).getAsJsonArray();
            for (int i = 0; i < root.size(); ++i) {
                JsonElement elem = root.get(i);
                APIException err = (APIException)serializer.fromJson(elem, eClass);
                if (err.code != null) {
                    this.errorsByIndex.put(i, err);
                    continue;
                }
                this.successesByIndex.put(i, serializer.fromJson(elem, tClass));
            }
        }
        catch (IllegalStateException e) {
            throw new JSONException("Unable to read body: " + e.getMessage(), response.headers().get("Chain-Request-ID"));
        }
    }

    public BatchResponse(Map<Integer, T> successes, Map<Integer, APIException> errors) {
        ArrayList<Integer> successIndexes = new ArrayList<Integer>();
        Iterator<Integer> successIter = successes.keySet().iterator();
        while (successIter.hasNext()) {
            successIndexes.add(successIter.next());
        }
        Collections.sort(successIndexes);
        Iterator iterator = successIndexes.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            this.successesByIndex.put(i, successes.get(i));
        }
        ArrayList<Integer> errorIndexes = new ArrayList<Integer>();
        Iterator<Integer> errorIter = errors.keySet().iterator();
        while (errorIter.hasNext()) {
            errorIndexes.add(errorIter.next());
        }
        Collections.sort(errorIndexes);
        Iterator iterator2 = errorIndexes.iterator();
        while (iterator2.hasNext()) {
            int i = (Integer)iterator2.next();
            this.errorsByIndex.put(i, errors.get(i));
        }
    }

    public Response response() {
        return this.response;
    }

    public int size() {
        return this.successesByIndex.size() + this.errorsByIndex.size();
    }

    public boolean isSuccess(int index) {
        return this.successesByIndex.containsKey(index);
    }

    public boolean isError(int index) {
        return this.errorsByIndex.containsKey(index);
    }

    public List<T> successes() {
        ArrayList<T> res = new ArrayList<T>();
        res.addAll(this.successesByIndex.values());
        return res;
    }

    public List<APIException> errors() {
        ArrayList<APIException> res = new ArrayList<APIException>();
        res.addAll(this.errorsByIndex.values());
        return res;
    }

    public Map<Integer, T> successesByIndex() {
        return this.successesByIndex;
    }

    public Map<Integer, APIException> errorsByIndex() {
        return this.errorsByIndex;
    }
}

