/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.common.ParameterizedTypeImpl;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.http.Client;
import java.util.List;
import org.apache.log4j.Logger;

public class UnspentOutput {
    @SerializedName(value="asset_id")
    public String assetId;
    @SerializedName(value="asset_alias")
    public String assetAlias;
    public long amount;
    public String address;
    public boolean change;
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="program")
    public String program;
    @SerializedName(value="control_program_index")
    public String controlProgramIndex;
    @SerializedName(value="source_id")
    public String sourceId;
    @SerializedName(value="source_pos")
    public int sourcePos;
    @SerializedName(value="valid_height")
    public int validHeight;
    private static Logger logger = Logger.getLogger(UnspentOutput.class);

    public String toJson() {
        return Utils.serializer.toJson((Object)this);
    }

    public static class QueryBuilder {
        public String id;
        @SerializedName(value="account_id")
        public String accountId;
        @SerializedName(value="account_alias")
        public String accountAlias;
        public Boolean unconfirmed;
        @SerializedName(value="smart_contract")
        public Boolean smartContract;
        public Integer from;
        public Integer count;

        public QueryBuilder setId(String id) {
            this.id = id;
            return this;
        }

        public QueryBuilder setAccountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public QueryBuilder setAccountAlias(String accountAlias) {
            this.accountAlias = accountAlias;
            return this;
        }

        public QueryBuilder setSmartContract(boolean smartContract) {
            this.smartContract = smartContract;
            return this;
        }

        public QueryBuilder setUnconfirmed(boolean unconfirmed) {
            this.unconfirmed = unconfirmed;
            return this;
        }

        public QueryBuilder setFrom(Integer from) {
            this.from = from;
            return this;
        }

        public QueryBuilder setCount(Integer count) {
            this.count = count;
            return this;
        }

        public List<UnspentOutput> list(Client client) throws BytomException {
            ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{UnspentOutput.class});
            List unspentOutputList = (List)client.request("list-unspent-outputs", this, listType);
            logger.info((Object)"list-unspent-outputs:");
            logger.info((Object)("size of unspentOutputList:" + unspentOutputList.size()));
            for (UnspentOutput UTXO : unspentOutputList) {
                logger.info((Object)UTXO.toJson());
            }
            return unspentOutputList;
        }
    }
}

