/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnconfirmedTransaction {
    private String id;
    private Integer version;
    private Integer size;
    @SerializedName(value="time_range")
    private Integer timeRange;
    @SerializedName(value="status_fail")
    private boolean statusFail;
    private List<AnnotatedInput> inputs;
    private List<AnnotatedOutput> outputs;
    private static Logger logger = Logger.getLogger(UnconfirmedTransaction.class);

    public String toJson() {
        return Utils.serializer.toJson((Object)this);
    }

    public static UnconfirmedTransaction get(Client client, String txId) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("tx_id", txId);
        UnconfirmedTransaction UCTX = (UnconfirmedTransaction)client.request("get-unconfirmed-transaction", req, (Type)((Object)UnconfirmedTransaction.class));
        logger.info((Object)"get-unconfirmed-transaction:");
        logger.info((Object)UCTX.toJson());
        return UCTX;
    }

    public static UTXResponse list(Client client) throws BytomException {
        UTXResponse utxResponse = (UTXResponse)client.request("list-unconfirmed-transactions", null, (Type)((Object)UTXResponse.class));
        logger.info((Object)"list-unconfirmed-transactions:");
        logger.info((Object)utxResponse.toJson());
        return utxResponse;
    }

    public static class AnnotatedOutput {
        private String address;
        private long amount;
        @SerializedName(value="asset_definition")
        private Map<String, Object> assetDefinition;
        @SerializedName(value="asset_id")
        public String assetId;
        @SerializedName(value="control_program")
        private String controlProgram;
        @SerializedName(value="id")
        private String id;
        private Integer position;
        private String type;
    }

    public static class AnnotatedInput {
        private String address;
        private long amount;
        @SerializedName(value="asset_definition")
        private Map<String, Object> assetDefinition;
        @SerializedName(value="asset_id")
        private String assetId;
        @SerializedName(value="control_program")
        private String controlProgram;
        @SerializedName(value="spent_output_id")
        private String spentOutputId;
        private String type;
    }

    public static class UTXResponse {
        @SerializedName(value="total")
        public Integer total;
        @SerializedName(value="tx_ids")
        public List<String> txIds;

        public String toJson() {
            return Utils.serializer.toJson((Object)this);
        }
    }
}

