/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.api.Receiver;
import io.bytom.common.ParameterizedTypeImpl;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Transaction {
    @SerializedName(value="tx_id")
    public String txId;
    @SerializedName(value="block_time")
    public String blockTime;
    @SerializedName(value="block_hash")
    public String blockHash;
    @SerializedName(value="block_index")
    public String blockIndex;
    @SerializedName(value="block_transactions_count")
    public String blockTransactionsCount;
    @SerializedName(value="block_height")
    public int blockHeight;
    @SerializedName(value="status_fail")
    public boolean statusFail;
    public List<Input> inputs;
    public List<Output> outputs;
    private static Logger logger = Logger.getLogger(Transaction.class);

    public String toJson() {
        return Utils.serializer.toJson((Object)this);
    }

    public static SubmitResponse submit(Client client, Template template) throws BytomException {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("raw_transaction", template.rawTransaction);
        return (SubmitResponse)client.request("submit-transaction", body, (Type)((Object)SubmitResponse.class));
    }

    public static TransactionGas estimateGas(Client client, Template template) throws BytomException {
        HashMap<String, Template> body = new HashMap<String, Template>();
        body.put("transaction_template", template);
        return (TransactionGas)client.request("estimate-transaction-gas", body, (Type)((Object)TransactionGas.class));
    }

    public static class Feed {
        public String alias;
        public String filter;
        public TransactionFeedParam param;
        private static Logger logger = Logger.getLogger(Transaction.class);

        public String toJson() {
            return Utils.serializer.toJson((Object)this);
        }

        public static Feed getByAlias(Client client, String alias) throws BytomException {
            HashMap<String, String> req = new HashMap<String, String>();
            req.put("alias", alias);
            Feed transactionFeed = (Feed)client.requestGet("get-transaction-feed", req, "txfeed", (Type)((Object)Feed.class));
            logger.info((Object)"get-transaction-feed.");
            logger.info((Object)transactionFeed.toJson());
            return transactionFeed;
        }

        public static void update(Client client, String alias, String filter) throws BytomException {
            HashMap<String, String> req = new HashMap<String, String>();
            req.put("alias", alias);
            req.put("filter", filter);
            client.request("update-transaction-feed", req);
            logger.info((Object)"update-transaction-feed successfully");
        }

        public static List<Feed> list(Client client) throws BytomException {
            ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{Feed.class});
            List transactionFeedList = (List)client.request("list-transaction-feeds", null, listType);
            logger.info((Object)"list-transaction-feeds:");
            logger.info((Object)("size of transactionList:" + transactionFeedList.size()));
            for (int i = 0; i < transactionFeedList.size(); ++i) {
                logger.info((Object)((Feed)transactionFeedList.get(i)).toJson());
            }
            return transactionFeedList;
        }

        public static void deleteByAlias(Client client, String alias) throws BytomException {
            HashMap<String, String> req = new HashMap<String, String>();
            req.put("alias", alias);
            client.request("delete-transaction-feed", req);
            logger.info((Object)"delete-transaction-feed successfully");
        }

        public class TransactionFeedParam {
            public String assetid;
            public long lowerlimit;
            public long upperlimit;
        }

        public static class Builder {
            public String alias;
            public String filter;

            public Builder setAlias(String alias) {
                this.alias = alias;
                return this;
            }

            public Builder setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public void create(Client client) throws BytomException {
                client.request("create-transaction-feed", this);
                logger.info((Object)"create-transaction-feed");
            }
        }
    }

    public static class TransactionGas {
        @SerializedName(value="total_neu")
        public int totalNeu;
        @SerializedName(value="storage_neu")
        public int storageNeu;
        @SerializedName(value="vm_neu")
        public int vmNeu;
    }

    public static class SubmitResponse {
        public String tx_id;

        public String toJson() {
            return Utils.serializer.toJson((Object)this);
        }
    }

    public static class Template {
        @SerializedName(value="raw_transaction")
        public String rawTransaction;
        @SerializedName(value="signing_instructions")
        public List<SigningInstruction> signingInstructions;
        @SerializedName(value="local")
        private boolean local;
        @SerializedName(value="allow_additional_actions")
        private boolean allowAdditionalActions;

        public Template allowAdditionalActions() {
            this.allowAdditionalActions = true;
            return this;
        }

        public String toJson() {
            return Utils.serializer.toJson((Object)this);
        }

        public static class KeyID {
            public String xpub;
            @SerializedName(value="derivation_path")
            public String[] derivationPath;
        }

        public static class WitnessComponent {
            public String type;
            public String value;
            public int quorum;
            public KeyID[] keys;
            public String[] signatures;
        }

        public static class SigningInstruction {
            public int position;
            @SerializedName(value="witness_components")
            public WitnessComponent[] witnessComponents;
        }
    }

    public static class Action
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 7948250382060074590L;

        public Action() {
            this.put("client_token", UUID.randomUUID().toString());
        }

        public Action setParameter(String key, Object value) {
            this.put(key, value);
            return this;
        }

        public static class Retire
        extends Action {
            private static final long serialVersionUID = -8434272436211832706L;

            public Retire() {
                this.put("type", "retire");
            }

            public Retire setAmount(long amount) {
                this.put("amount", amount);
                return this;
            }

            public Retire setAssetAlias(String alias) {
                this.put("asset_alias", alias);
                return this;
            }

            public Retire setAssetId(String id) {
                this.put("asset_id", id);
                return this;
            }

            public Retire setArbitrary(String arbitrary) {
                this.put("arbitrary", arbitrary);
                return this;
            }

            public Retire setAccountAlias(String alias) {
                this.put("account_alias", alias);
                return this;
            }

            public Retire setAccountId(String id) {
                this.put("account_id", id);
                return this;
            }
        }

        public static class ControlWithReceiver
        extends Action {
            private static final long serialVersionUID = 7280759134960453401L;

            public ControlWithReceiver() {
                this.put("type", "control_receiver");
            }

            public ControlWithReceiver setReceiver(Receiver receiver) {
                this.put("receiver", receiver);
                return this;
            }

            public ControlWithReceiver setAssetAlias(String alias) {
                this.put("asset_alias", alias);
                return this;
            }

            public ControlWithReceiver setAssetId(String id) {
                this.put("asset_id", id);
                return this;
            }

            public ControlWithReceiver setAmount(long amount) {
                this.put("amount", amount);
                return this;
            }
        }

        public static class ControlWithAddress
        extends Action {
            private static final long serialVersionUID = 1292007349260961499L;

            public ControlWithAddress() {
                this.put("type", "control_address");
            }

            public ControlWithAddress setAddress(String address) {
                this.put("address", address);
                return this;
            }

            public ControlWithAddress setAssetAlias(String alias) {
                this.put("asset_alias", alias);
                return this;
            }

            public ControlWithAddress setAssetId(String id) {
                this.put("asset_id", id);
                return this;
            }

            public ControlWithAddress setAmount(long amount) {
                this.put("amount", amount);
                return this;
            }
        }

        public static class ControlWithAccount
        extends Action {
            private static final long serialVersionUID = -1067464339402520620L;

            public ControlWithAccount() {
                this.put("type", "control_account");
            }

            public ControlWithAccount setAccountAlias(String alias) {
                this.put("account_alias", alias);
                return this;
            }

            public ControlWithAccount setAccountId(String id) {
                this.put("account_id", id);
                return this;
            }

            public ControlWithAccount setAssetAlias(String alias) {
                this.put("asset_alias", alias);
                return this;
            }

            public ControlWithAccount setAssetId(String id) {
                this.put("asset_id", id);
                return this;
            }

            public ControlWithAccount setAmount(long amount) {
                this.put("amount", amount);
                return this;
            }
        }

        public static class SpendFromAccount
        extends Action {
            private static final long serialVersionUID = 6444162327409625893L;

            public SpendFromAccount() {
                this.put("type", "spend_account");
            }

            public SpendFromAccount setAccountAlias(String alias) {
                this.put("account_alias", alias);
                return this;
            }

            public SpendFromAccount setAccountId(String id) {
                this.put("account_id", id);
                return this;
            }

            public SpendFromAccount setAssetAlias(String alias) {
                this.put("asset_alias", alias);
                return this;
            }

            public SpendFromAccount setAssetId(String id) {
                this.put("asset_id", id);
                return this;
            }

            public SpendFromAccount setAmount(long amount) {
                this.put("amount", amount);
                return this;
            }
        }

        public static class Issue
        extends Action {
            private static final long serialVersionUID = -6296543909434749786L;

            public Issue() {
                this.put("type", "issue");
            }

            public Issue setAssetAlias(String alias) {
                this.put("asset_alias", alias);
                return this;
            }

            public Issue setAssetId(String id) {
                this.put("asset_id", id);
                return this;
            }

            public Issue setAmount(long amount) {
                this.put("amount", amount);
                return this;
            }
        }
    }

    public static class Output {
        @SerializedName(value="id")
        public String id;
        public String type;
        public int position;
        @SerializedName(value="control_program")
        public String controlProgram;
        @SerializedName(value="asset_id")
        public String assetId;
        @SerializedName(value="asset_alias")
        public String assetAlias;
        @SerializedName(value="asset_definition")
        public Map<String, Object> assetDefinition;
        public long amount;
        @SerializedName(value="account_id")
        public String accountId;
        @SerializedName(value="account_alias")
        public String accountAlias;
        @SerializedName(value="address")
        public String address;
    }

    public static class Input {
        @SerializedName(value="account_alias")
        public String accountAlias;
        @SerializedName(value="account_id")
        public String accountId;
        @SerializedName(value="address")
        public String address;
        public long amount;
        @SerializedName(value="asset_alias")
        public String assetAlias;
        @SerializedName(value="asset_definition")
        public Map<String, Object> assetDefinition;
        @SerializedName(value="asset_id")
        public String assetId;
        @SerializedName(value="spent_output_id")
        public String spentOutputId;
        public String type;
        public String arbitrary;
        @SerializedName(value="control_program")
        public String controlProgram;
    }

    public static class SignerBuilder {
        public Template sign(Client client, Template template, String password) throws BytomException {
            HashMap<String, Object> req = new HashMap<String, Object>();
            req.put("transaction", template);
            req.put("password", password);
            Template templateResult = (Template)client.requestGet("sign-transaction", req, "transaction", (Type)((Object)Template.class));
            logger.info((Object)"sign-transaction:");
            logger.info((Object)templateResult.toJson());
            return templateResult;
        }
    }

    public static class QueryBuilder {
        public String txId;
        public String accountId;

        public QueryBuilder setTxId(String txId) {
            this.txId = txId;
            return this;
        }

        public QueryBuilder setAccountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public List<Transaction> list(Client client) throws BytomException {
            ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{Transaction.class});
            List transactionList = (List)client.request("list-transactions", null, listType);
            logger.info((Object)"list-transactions:");
            logger.info((Object)("size of transactionList:" + transactionList.size()));
            logger.info((Object)"all transactions:");
            for (int i = 0; i < transactionList.size(); ++i) {
                logger.info((Object)((Transaction)transactionList.get(i)).toJson());
            }
            return transactionList;
        }

        public List<Transaction> listById(Client client) throws BytomException {
            HashMap<String, Object> req = new HashMap<String, Object>();
            req.put("tx_id", this.txId);
            req.put("detail", true);
            ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{Transaction.class});
            List transactionList = (List)client.request("list-transactions", req, listType);
            logger.info((Object)"list-transactions:");
            logger.info((Object)("size of transactionList:" + transactionList.size()));
            logger.info((Object)"all transactions:");
            for (int i = 0; i < transactionList.size(); ++i) {
                logger.info((Object)((Transaction)transactionList.get(i)).toJson());
            }
            return transactionList;
        }

        public List<Transaction> listByAccountId(Client client) throws BytomException {
            HashMap<String, String> req = new HashMap<String, String>();
            req.put("account_id", this.accountId);
            ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{Transaction.class});
            List transactionList = (List)client.request("list-transactions", req, listType);
            logger.info((Object)"list-transactions:");
            logger.info((Object)("size of transactionList:" + transactionList.size()));
            logger.info((Object)"all transactions:");
            for (int i = 0; i < transactionList.size(); ++i) {
                logger.info((Object)((Transaction)transactionList.get(i)).toJson());
            }
            return transactionList;
        }

        public Transaction get(Client client) throws BytomException {
            HashMap<String, String> req = new HashMap<String, String>();
            req.put("tx_id", this.txId);
            Transaction transaction = (Transaction)client.request("get-transaction", req, (Type)((Object)Transaction.class));
            logger.info((Object)"get-transaction:");
            logger.info((Object)transaction.toJson());
            return transaction;
        }
    }

    public static class Builder {
        @SerializedName(value="base_transaction")
        protected String baseTransaction;
        protected List<Action> actions;
        protected long ttl;

        public Template build(Client client) throws BytomException {
            return (Template)client.request("build-transaction", this, (Type)((Object)Template.class));
        }

        public Builder() {
            this.actions = new ArrayList<Action>();
        }

        public Builder(String baseTransaction) {
            this.setBaseTransaction(baseTransaction);
            this.actions = new ArrayList<Action>();
        }

        public Builder setBaseTransaction(String baseTransaction) {
            this.baseTransaction = baseTransaction;
            return this;
        }

        public Builder addAction(Action action) {
            this.actions.add(action);
            return this;
        }

        public Builder setTtl(long ms) {
            this.ttl = ms;
            return this;
        }
    }
}

