/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RawTransaction {
    public Integer version;
    public Integer size;
    @SerializedName(value="time_range")
    public Integer timeRange;
    public Integer fee;
    public List<AnnotatedInput> inputs;
    public List<AnnotatedOutput> outputs;
    private static Logger logger = Logger.getLogger(RawTransaction.class);

    public String toJson() {
        return Utils.serializer.toJson((Object)this);
    }

    public static RawTransaction decode(Client client, String txId) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("raw_transaction", txId);
        RawTransaction rawTransaction = (RawTransaction)client.request("decode-raw-transaction", req, (Type)((Object)RawTransaction.class));
        logger.info((Object)"decode-raw-transaction:");
        logger.info((Object)rawTransaction.toJson());
        return rawTransaction;
    }

    public static class AnnotatedOutput {
        private String address;
        private long amount;
        @SerializedName(value="asset_definition")
        private Map<String, Object> assetDefinition;
        @SerializedName(value="asset_id")
        public String assetId;
        @SerializedName(value="control_program")
        private String controlProgram;
        @SerializedName(value="id")
        private String id;
        private Integer position;
        private String type;
    }

    public static class AnnotatedInput {
        private String address;
        private long amount;
        @SerializedName(value="asset_definition")
        private Map<String, Object> assetDefinition;
        @SerializedName(value="asset_id")
        private String assetId;
        @SerializedName(value="control_program")
        private String controlProgram;
        @SerializedName(value="spent_output_id")
        private String spentOutputId;
        private String type;
    }
}

