/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import org.apache.log4j.Logger;

public class Message {
    @SerializedName(value="derived_xpub")
    public String derivedXpub;
    @SerializedName(value="signature")
    public String signature;
    private static Logger logger = Logger.getLogger(Message.class);

    public String toJson() {
        return Utils.serializer.toJson((Object)this);
    }

    public static class VerifyBuilder {
        public String address;
        @SerializedName(value="derived_xpub")
        public String derivedXpub;
        public String message;
        public String signature;

        public VerifyBuilder setAddress(String address) {
            this.address = address;
            return this;
        }

        public VerifyBuilder setDerivedXpub(String derivedXpub) {
            this.derivedXpub = derivedXpub;
            return this;
        }

        public VerifyBuilder setMessage(String message) {
            this.message = message;
            return this;
        }

        public VerifyBuilder setSignature(String signature) {
            this.signature = signature;
            return this;
        }

        public Boolean verifyMessage(Client client) throws BytomException {
            Boolean result = (Boolean)client.requestGet("verify-message", this, "result", (Type)((Object)Boolean.class));
            logger.info((Object)("verify-message:" + result));
            return result;
        }
    }

    public static class SignBuilder {
        public String address;
        public String message;
        public String password;

        public SignBuilder setAddress(String address) {
            this.address = address;
            return this;
        }

        public SignBuilder setMessage(String message) {
            this.message = message;
            return this;
        }

        public SignBuilder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Message sign(Client client) throws BytomException {
            Message message = (Message)client.request("sign-message", this, (Type)((Object)Message.class));
            logger.info((Object)"sign-message:");
            logger.info((Object)message.toJson());
            return message;
        }
    }
}

