/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.common.ParameterizedTypeImpl;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class Key {
    @SerializedName(value="alias")
    public String alias;
    @SerializedName(value="xpub")
    public String xpub;
    @SerializedName(value="file")
    public String file;
    private static Logger logger = Logger.getLogger(Key.class);

    public String toJson() {
        return Utils.serializer.toJson((Object)this);
    }

    public static Key create(Client client, Builder builder) throws BytomException {
        Key key = (Key)client.request("create-key", builder, (Type)((Object)Key.class));
        return key;
    }

    public static List<Key> list(Client client) throws BytomException {
        ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{Key.class});
        List keyList = (List)client.request("list-keys", null, listType);
        logger.info((Object)"list-key:");
        logger.info((Object)("size of key:" + keyList.size()));
        logger.info((Object)keyList);
        return keyList;
    }

    public static void delete(Client client, String xpub, String password) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("xpub", xpub);
        req.put("password", password);
        client.request("delete-key", req);
        logger.info((Object)"delete-key successfully.");
    }

    public static void resetPassword(Client client, String xpub, String oldPwd, String newPwd) throws BytomException {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("xpub", xpub);
        req.put("old_password", oldPwd);
        req.put("new_password", newPwd);
        client.request("reset-key-password", req);
    }

    public String toString() {
        return "Key{alias='" + this.alias + '\'' + ", xpub='" + this.xpub + '\'' + ", file='" + this.file + '\'' + '}';
    }

    public static class Builder {
        public String alias;
        public String password;

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }
    }
}

