/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.api.Transaction;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.log4j.Logger;

public class Block {
    public String hash;
    public Integer size;
    public Integer version;
    public Integer height;
    @SerializedName(value="previous_block_hash")
    public String previousBlockHash;
    public Integer timestamp;
    public Integer nonce;
    public long bits;
    public String difficulty;
    @SerializedName(value="transaction_merkle_root")
    public String transactionsMerkleRoot;
    @SerializedName(value="transaction_status_hash")
    public String transactionStatusHash;
    public List<Transaction> transactions;
    private static Logger logger = Logger.getLogger(Block.class);

    public String toJson() {
        return Utils.serializer.toJson((Object)this);
    }

    public static Integer getBlockCount(Client client) throws BytomException {
        Integer blockCount = (Integer)client.requestGet("get-block-count", null, "block_count", (Type)((Object)Integer.class));
        logger.info((Object)("get-block-count:" + blockCount));
        return blockCount;
    }

    public static String getBlockHash(Client client) throws BytomException {
        String blockHash = (String)client.requestGet("get-block-hash", null, "block_hash", (Type)((Object)String.class));
        logger.info((Object)("get-block-hash:" + blockHash));
        return blockHash;
    }

    public static class BlockHashRate {
        public String hash;
        public Integer height;
        public Integer hash_rate;

        public String toJson() {
            return Utils.serializer.toJson((Object)this);
        }
    }

    public static class BlockDifficulty {
        public String hash;
        public Integer height;
        public Integer bits;
        public String difficulty;

        public String toJson() {
            return Utils.serializer.toJson((Object)this);
        }
    }

    public static class BlockHeader {
        @SerializedName(value="block_header")
        public String blockHeader;
        @SerializedName(value="reward")
        public Integer reward;

        public String toJson() {
            return Utils.serializer.toJson((Object)this);
        }
    }

    public static class QueryBuilder {
        @SerializedName(value="block_height")
        public int blockHeight;
        @SerializedName(value="block_hash")
        public String blockHash;

        public QueryBuilder setBlockHeight(int blockHeight) {
            this.blockHeight = blockHeight;
            return this;
        }

        public QueryBuilder setBlockHash(String blockHash) {
            this.blockHash = blockHash;
            return this;
        }

        public Block getBlock(Client client) throws BytomException {
            Block block = (Block)client.request("get-block", this, (Type)((Object)Block.class));
            logger.info((Object)"get-block:");
            logger.info((Object)block.toJson());
            return block;
        }

        public BlockHeader getBlockHeader(Client client) throws BytomException {
            BlockHeader blockHeader = (BlockHeader)client.request("get-block-header", this, (Type)((Object)BlockHeader.class));
            logger.info((Object)"get-block-header:");
            logger.info((Object)blockHeader.toJson());
            return blockHeader;
        }

        public BlockDifficulty getBlockDifficulty(Client client) throws BytomException {
            BlockDifficulty blockDifficulty = (BlockDifficulty)client.request("get-difficulty", this, (Type)((Object)BlockDifficulty.class));
            logger.info((Object)"get-difficulty:");
            logger.info((Object)blockDifficulty.toJson());
            return blockDifficulty;
        }

        public BlockHashRate getHashRate(Client client) throws BytomException {
            BlockHashRate blockHashRate = (BlockHashRate)client.request("get-hash-rate", this, (Type)((Object)BlockHashRate.class));
            logger.info((Object)"get-hash-rate:");
            logger.info((Object)blockHashRate.toJson());
            return blockHashRate;
        }
    }
}

