/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.common.ParameterizedTypeImpl;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.http.Client;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Balance {
    @SerializedName(value="account_id")
    public String accountId;
    @SerializedName(value="account_alias")
    public String accountAlias;
    public long amount;
    @SerializedName(value="asset_id")
    public String assetId;
    @SerializedName(value="asset_alias")
    public String assetAlias;
    @SerializedName(value="asset_definition")
    public Map<String, Object> definition;
    private static Logger logger = Logger.getLogger(Balance.class);

    public String toJson() {
        return Utils.serializer.toJson((Object)this);
    }

    public static class QueryBuilder {
        public List<Balance> list(Client client) throws BytomException {
            ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{Balance.class});
            List balanceList = (List)client.request("list-balances", null, listType);
            logger.info((Object)"list-balances:");
            logger.info((Object)("size of :" + balanceList.size()));
            for (Balance result : balanceList) {
                logger.info((Object)result.toJson());
            }
            return balanceList;
        }

        public Balance listByAssetAlias(Client client, String assetAlias) throws BytomException {
            List<Balance> balanceList = this.list(client);
            Balance assetBalance = new Balance();
            assetBalance.assetAlias = assetAlias;
            long amount = 0L;
            for (Balance result : balanceList) {
                if (!result.assetAlias.equals(assetAlias)) continue;
                amount += result.amount;
                assetBalance.assetId = result.assetId;
            }
            assetBalance.amount = amount;
            logger.info((Object)assetBalance.toJson());
            return assetBalance;
        }

        public List<Balance> listByAccountAlias(Client client, String accountAlias) throws BytomException {
            List<Balance> balanceList = this.list(client);
            ArrayList<Balance> accountBalance = new ArrayList<Balance>();
            for (Balance result : balanceList) {
                if (!result.accountAlias.equals(accountAlias)) continue;
                accountBalance.add(result);
                logger.info((Object)result.toJson());
            }
            return accountBalance;
        }
    }
}

