/*
 * Decompiled with CFR 0.152.
 */
package io.bytom.api;

import com.google.gson.annotations.SerializedName;
import io.bytom.common.ParameterizedTypeImpl;
import io.bytom.common.Utils;
import io.bytom.exception.BytomException;
import io.bytom.http.Client;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Asset {
    public String id;
    public String alias;
    @SerializedName(value="issuance_program", alternate={"issue_program"})
    public String issuanceProgram;
    public Key[] keys;
    @SerializedName(value="key_index")
    public Integer keyIndex;
    @SerializedName(value="xpubs")
    public List<String> xpubs;
    @SerializedName(value="quorum")
    public int quorum;
    @SerializedName(value="definition")
    public Map<String, Object> definition;
    @SerializedName(value="vm_version")
    public int vmVersion;
    @SerializedName(value="type")
    public String type;
    @SerializedName(value="raw_definition_byte")
    public String rawDefinitionByte;
    public static Logger logger = Logger.getLogger(Asset.class);

    public String toJson() {
        return Utils.serializer.toJson((Object)this);
    }

    public String toString() {
        return "Asset{id='" + this.id + '\'' + ", alias='" + this.alias + '\'' + ", issuanceProgram='" + this.issuanceProgram + '\'' + ", keys=" + Arrays.toString(this.keys) + ", keyIndex=" + this.keyIndex + ", xpubs=" + this.xpubs + ", quorum=" + this.quorum + ", definition=" + this.definition + ", vmVersion=" + this.vmVersion + ", type='" + this.type + '\'' + ", rawDefinitionByte='" + this.rawDefinitionByte + '\'' + '}';
    }

    public static class AliasUpdateBuilder {
        @SerializedName(value="id")
        public String id;
        @SerializedName(value="alias")
        public String alias;

        public AliasUpdateBuilder setAssetId(String assetId) {
            this.id = assetId;
            return this;
        }

        public AliasUpdateBuilder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public void update(Client client) throws BytomException {
            client.request("update-asset-alias", this);
            logger.info((Object)"update-asset-alias:");
            logger.info((Object)("id:" + this.id));
            logger.info((Object)("alias:" + this.alias));
        }
    }

    public static class QueryBuilder {
        @SerializedName(value="id")
        public String id;

        public QueryBuilder setId(String assetId) {
            this.id = assetId;
            return this;
        }

        public Asset get(Client client) throws BytomException {
            Asset asset = (Asset)client.request("get-asset", this, (Type)((Object)Asset.class));
            logger.info((Object)"get-asset:");
            logger.info((Object)asset.toJson());
            return asset;
        }

        public List<Asset> list(Client client) throws BytomException {
            ParameterizedTypeImpl listType = new ParameterizedTypeImpl(List.class, new Class[]{Asset.class});
            List assetList = (List)client.request("list-assets", this, listType);
            logger.info((Object)"list-assets:");
            logger.info((Object)("size of assetList:" + assetList.size()));
            logger.info((Object)assetList);
            return assetList;
        }
    }

    public static class Builder {
        public String alias;
        public Map<String, Object> definition;
        @SerializedName(value="root_xpubs")
        public List<String> rootXpubs = new ArrayList<String>();
        public int quorum;
        @SerializedName(value="access_token")
        private String access_token;

        public Asset create(Client client) throws BytomException {
            Asset asset = (Asset)client.request("create-asset", this, (Type)((Object)Asset.class));
            logger.info((Object)"create-asset:");
            logger.info((Object)asset.toString());
            return asset;
        }

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder addDefinitionField(String key, Object value) {
            if (this.definition == null) {
                this.definition = new HashMap<String, Object>();
            }
            this.definition.put(key, value);
            return this;
        }

        public Builder setDefinition(Map<String, Object> definition) {
            this.definition = definition;
            return this;
        }

        public Builder setQuorum(int quorum) {
            this.quorum = quorum;
            return this;
        }

        public Builder addRootXpub(String xpub) {
            this.rootXpubs.add(xpub);
            return this;
        }

        public Builder setRootXpubs(List<String> xpubs) {
            this.rootXpubs = new ArrayList<String>(xpubs);
            return this;
        }

        public String toString() {
            return "Builder{alias='" + this.alias + '\'' + ", definition=" + this.definition + ", rootXpubs=" + this.rootXpubs + ", quorum=" + this.quorum + ", access_token='" + this.access_token + '\'' + '}';
        }
    }

    public static class Key {
        @SerializedName(value="root_xpub")
        public String rootXpub;
        @SerializedName(value="asset_pubkey")
        public String assetPubkey;
        @SerializedName(value="asset_derivation_path")
        public String[] assetDerivationPath;

        public String toString() {
            return "Key{rootXpub='" + this.rootXpub + '\'' + ", assetPubkey='" + this.assetPubkey + '\'' + ", assetDerivationPath=" + Arrays.toString(this.assetDerivationPath) + '}';
        }
    }
}

